/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultUniEmitter<T>
implements UniEmitter<T>,
UniSubscription {
    private final UniSubscriber<T> downstream;
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final AtomicReference<Runnable> onTermination = new AtomicReference();

    DefaultUniEmitter(UniSubscriber<T> subscriber) {
        this.downstream = ParameterValidation.nonNull(subscriber, "subscriber");
    }

    @Override
    public void complete(T item) {
        if (this.disposed.compareAndSet(false, true)) {
            this.downstream.onItem(item);
            this.terminate();
        }
    }

    private void terminate() {
        Runnable runnable = this.onTermination.getAndSet(null);
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public void fail(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        if (this.disposed.compareAndSet(false, true)) {
            this.downstream.onFailure(failure);
            this.terminate();
        }
    }

    @Override
    public UniEmitter<T> onTermination(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        if (!this.disposed.get()) {
            this.onTermination.set(actual);
            if (this.disposed.get()) {
                this.terminate();
            }
        }
        return this;
    }

    @Override
    public void cancel() {
        if (this.disposed.compareAndSet(false, true)) {
            this.terminate();
        }
    }

    public boolean isTerminated() {
        return this.disposed.get();
    }
}

