/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.context;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.MultiInterceptor;
import io.smallrye.mutiny.operators.AbstractMulti;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ContextPropagationMultiInterceptor
implements MultiInterceptor {
    static final ThreadContext THREAD_CONTEXT = ContextManagerProvider.instance().getContextManager().newThreadContextBuilder().build();

    @Override
    public <T> Subscriber<? super T> onSubscription(Publisher<? extends T> instance, final Subscriber<? super T> subscriber) {
        final Executor executor = THREAD_CONTEXT.currentContextExecutor();
        return new Subscriber<T>(){

            @Override
            public void onSubscribe(Subscription subscription) {
                executor.execute(() -> subscriber.onSubscribe(subscription));
            }

            @Override
            public void onNext(T item) {
                executor.execute(() -> subscriber.onNext(item));
            }

            @Override
            public void onError(Throwable failure) {
                executor.execute(() -> subscriber.onError(failure));
            }

            @Override
            public void onComplete() {
                executor.execute(subscriber::onComplete);
            }
        };
    }

    @Override
    public <T> Multi<T> onMultiCreation(final Multi<T> multi) {
        final Executor executor = THREAD_CONTEXT.currentContextExecutor();
        return new AbstractMulti<T>(){

            @Override
            public void subscribe(Subscriber<? super T> subscriber) {
                executor.execute(() -> multi.subscribe().withSubscriber(subscriber));
            }
        };
    }
}

