/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.build.impl.JwtClaimsBuilderImpl;
import io.smallrye.jwt.build.spi.JwtProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.JsonObject;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JwtProviderImpl
extends JwtProvider {
    @Override
    public JwtClaimsBuilder claims() {
        return new JwtClaimsBuilderImpl();
    }

    @Override
    public JwtClaimsBuilder claims(Map<String, Object> claims) {
        return new JwtClaimsBuilderImpl(claims);
    }

    @Override
    public JwtClaimsBuilder claims(JsonObject jsonObject) {
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            claims.put((String)entry.getKey(), entry.getValue());
        }
        return this.claims(claims);
    }

    @Override
    public JwtClaimsBuilder claims(String jsonLocation) {
        return new JwtClaimsBuilderImpl(jsonLocation);
    }

    @Override
    public JwtClaimsBuilder claims(JsonWebToken jwt) {
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        for (String name : jwt.getClaimNames()) {
            if (Claims.raw_token.name().equals(name)) continue;
            claims.put(name, jwt.getClaim(name));
        }
        return this.claims(claims);
    }
}

