/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConfigSource;
import io.smallrye.config.ConfigValueConfigSourceWrapper;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.microprofile.config.spi.ConfigSource;

class SmallRyeConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 5513331820671039755L;
    private final ConfigValueConfigSource configSource;

    private SmallRyeConfigSourceInterceptor(ConfigSource configSource) {
        this(ConfigValueConfigSourceWrapper.wrap(configSource));
    }

    private SmallRyeConfigSourceInterceptor(ConfigValueConfigSource configSource) {
        this.configSource = configSource;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        ConfigValue configValue = this.configSource.getConfigValue(name);
        return configValue != null ? configValue : context.proceed(name);
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        context.iterateNames().forEachRemaining(names::add);
        names.addAll(this.configSource.getPropertyNames());
        return names.iterator();
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        HashSet<ConfigValue> values = new HashSet<ConfigValue>();
        context.iterateValues().forEachRemaining(values::add);
        values.addAll(this.configSource.getConfigValueProperties().values());
        return values.iterator();
    }

    public static ConfigSourceInterceptor configSourceInterceptor(ConfigSource configSource) {
        return new SmallRyeConfigSourceInterceptor(configSource);
    }
}

