/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class DeferredScalarSubscriber<T, R>
extends DeferredScalarSubscription<R>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = 2984505488220891551L;
    protected Subscription upstream;
    protected boolean hasValue;

    public DeferredScalarSubscriber(Subscriber<? super R> downstream) {
        super(downstream);
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.upstream, s)) {
            this.upstream = s;
            this.downstream.onSubscribe(this);
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onError(Throwable t) {
        this.value = null;
        this.downstream.onError(t);
    }

    @Override
    public void onComplete() {
        if (this.hasValue) {
            this.complete(this.value);
        } else {
            this.downstream.onComplete();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.upstream.cancel();
    }
}

