/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@ApplicationScoped
public class OpenApiDocumentProducer {
    private OpenApiDocument document;

    @PostConstruct
    void create() throws IOException {
        block24: {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("META-INF/quarkus-generated-openapi-doc." + (Object)((Object)Format.JSON));){
                if (is == null) break block24;
                try (OpenApiStaticFile staticFile = new OpenApiStaticFile(is, Format.JSON);){
                    Config config = ConfigProvider.getConfig();
                    OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
                    OpenAPI readerModel = OpenApiProcessor.modelFromReader(openApiConfig, Thread.currentThread().getContextClassLoader());
                    this.document = OpenApiDocument.INSTANCE;
                    this.document.reset();
                    this.document.config(openApiConfig);
                    this.document.modelFromReader(readerModel);
                    this.document.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile(staticFile));
                    this.document.filter(OpenApiProcessor.getFilter(openApiConfig, Thread.currentThread().getContextClassLoader()));
                    this.document.initialize();
                }
            }
        }
    }

    @Produces
    @Dependent
    OpenApiDocument openApiDocument() {
        return this.document;
    }
}

