/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.resteasy.runtime.standalone.LazyHostSupplier;
import io.quarkus.resteasy.runtime.standalone.VertxHttpResponse;
import io.quarkus.runtime.BlockingOperationControl;
import io.vertx.core.Context;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.RunnableWithException;

public final class VertxHttpRequest
extends BaseHttpRequest {
    private ResteasyHttpHeaders httpHeaders;
    private String httpMethod;
    private LazyHostSupplier remoteHost;
    private InputStream inputStream;
    private VertxHttpResponse response;
    private VertxExecutionContext executionContext;
    private final RoutingContext routingContext;
    private final Context context;
    private final ManagedContext requestContext;
    private final InjectableContext.ContextState requestContextState;
    private final Executor executor;

    public VertxHttpRequest(Context context, RoutingContext routingContext, ResteasyHttpHeaders httpHeaders, ResteasyUriInfo uri, String httpMethod, LazyHostSupplier remoteHost, SynchronousDispatcher dispatcher, VertxHttpResponse response, ManagedContext requestContext, Executor executor) {
        super(uri);
        this.executor = executor;
        this.context = context;
        this.response = response;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.remoteHost = remoteHost;
        this.executionContext = new VertxExecutionContext(this, response, dispatcher);
        this.requestContext = requestContext;
        this.requestContextState = requestContext.getState();
        this.routingContext = routingContext;
    }

    @Override
    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    @Override
    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        final Map<String, Object> attributes = this.routingContext.data();
        if (attributes == null) {
            return Collections.emptyEnumeration();
        }
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    @Override
    public ResteasyAsynchronousContext getAsyncContext() {
        return this.executionContext;
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.routingContext.get(attribute);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.routingContext.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.routingContext.remove(name);
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost.getRemoteHost();
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteHost.getRemoteHost();
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public VertxHttpResponse getResponse() {
        return this.response;
    }

    @Override
    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    @Override
    public boolean wasForwarded() {
        return false;
    }

    class VertxExecutionContext
    extends AbstractExecutionContext {
        protected final VertxHttpRequest request;
        protected final VertxHttpResponse response;
        protected volatile boolean done;
        protected volatile boolean cancelled;
        protected volatile boolean wasSuspended;
        protected VertxHttpAsyncResponse asyncResponse;

        VertxExecutionContext(VertxHttpRequest request, VertxHttpResponse response, SynchronousDispatcher dispatcher) {
            super(dispatcher, request, response);
            this.request = request;
            this.response = response;
            this.asyncResponse = new VertxHttpAsyncResponse(dispatcher, request, response);
        }

        @Override
        public boolean isSuspended() {
            return this.wasSuspended;
        }

        @Override
        public ResteasyAsynchronousResponse getAsyncResponse() {
            return this.asyncResponse;
        }

        @Override
        public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
            return this.suspend(-1L);
        }

        @Override
        public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
            return this.suspend(millis, TimeUnit.MILLISECONDS);
        }

        @Override
        public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
            if (this.wasSuspended) {
                throw new IllegalStateException("Request already suspended");
            }
            this.wasSuspended = true;
            return this.asyncResponse;
        }

        @Override
        public void complete() {
            if (this.wasSuspended && this.asyncResponse != null) {
                this.asyncResponse.complete();
            }
        }

        @Override
        public CompletionStage<Void> executeAsyncIo(CompletionStage<Void> f) {
            CompletableFuture<Void> ret = f.toCompletableFuture();
            if (!ret.isDone() && !this.isSuspended()) {
                this.suspend();
            }
            return ret;
        }

        @Override
        public CompletionStage<Void> executeBlockingIo(RunnableWithException f, boolean hasInterceptors) {
            if (!Context.isOnEventLoopThread()) {
                try {
                    f.run();
                }
                catch (Exception e) {
                    CompletableFuture<Void> ret = new CompletableFuture<Void>();
                    ret.completeExceptionally(e);
                    return ret;
                }
                return CompletableFuture.completedFuture(null);
            }
            if (!hasInterceptors) {
                Map<Class<?>, Object> context = ResteasyContext.getContextDataMap();
                if (!this.isSuspended()) {
                    this.suspend();
                }
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                this.request.context.executeBlocking(future -> {
                    try (ResteasyContext.CloseableContext newContext = ResteasyContext.addCloseableContextDataLevel(context);){
                        f.run();
                        future.complete();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, res -> {
                    if (res.succeeded()) {
                        ret.complete(null);
                    } else {
                        ret.completeExceptionally(res.cause());
                    }
                });
                return ret;
            }
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(new RuntimeException("Cannot use blocking IO with interceptors when we're on the IO thread"));
            return ret;
        }

        class VertxHttpAsyncResponse
        extends AbstractAsynchronousResponse {
            private final Object responseLock;
            private long timerID;
            private VertxHttpResponse vertxResponse;

            VertxHttpAsyncResponse(SynchronousDispatcher dispatcher, VertxHttpRequest request, VertxHttpResponse response) {
                super(dispatcher, request, response);
                this.responseLock = new Object();
                this.timerID = -1L;
                this.vertxResponse = response;
            }

            @Override
            public void initialRequestThreadFinished() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done || VertxExecutionContext.this.cancelled) {
                        return;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxHttpRequest.this.requestContext.activate(VertxHttpRequest.this.requestContextState);
                    VertxHttpRequest.this.requestContext.terminate();
                    if (BlockingOperationControl.isBlockingAllowed()) {
                        this.vertxFlush();
                    } else {
                        VertxHttpRequest.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                VertxHttpAsyncResponse.this.vertxFlush();
                            }
                        });
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean resume(Object entity) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    if (VertxExecutionContext.this.cancelled) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxHttpRequest.this.requestContext.activate(VertxHttpRequest.this.requestContextState);
                    return this.internalResume(entity, (Consumer<Throwable>)new FlushTask());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean resume(Throwable ex) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    if (VertxExecutionContext.this.cancelled) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxHttpRequest.this.requestContext.activate(VertxHttpRequest.this.requestContextState);
                    return this.internalResume(ex, (Consumer<Throwable>)new FlushTask());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxExecutionContext.this.cancelled = true;
                    VertxHttpRequest.this.requestContext.activate(VertxHttpRequest.this.requestContextState);
                    return this.internalResume(Response.status(Response.Status.SERVICE_UNAVAILABLE).build(), (Consumer<Throwable>)new FlushTask());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(int retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxExecutionContext.this.cancelled = true;
                    VertxHttpRequest.this.requestContext.activate(VertxHttpRequest.this.requestContextState);
                    return this.internalResume(Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build(), (Consumer<Throwable>)new FlushTask());
                }
            }

            protected synchronized void vertxFlush() {
                try {
                    this.vertxResponse.finish();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(Date retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (VertxExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxExecutionContext.this.cancelled = true;
                    VertxHttpRequest.this.requestContext.activate(VertxHttpRequest.this.requestContextState);
                    try {
                        bl = this.internalResume(Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build(), (Throwable t) -> this.vertxFlush());
                        VertxHttpRequest.this.requestContext.terminate();
                    }
                    catch (Throwable throwable) {
                        VertxHttpRequest.this.requestContext.terminate();
                        throw throwable;
                    }
                    return bl;
                }
            }

            @Override
            public boolean isSuspended() {
                return !VertxExecutionContext.this.done && !VertxExecutionContext.this.cancelled;
            }

            @Override
            public boolean isCancelled() {
                return VertxExecutionContext.this.cancelled;
            }

            @Override
            public boolean isDone() {
                return VertxExecutionContext.this.done;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setTimeout(long time, TimeUnit unit) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done || VertxExecutionContext.this.cancelled) {
                        return false;
                    }
                    if (this.timerID > -1L && !VertxHttpRequest.this.context.owner().cancelTimer(this.timerID)) {
                        return false;
                    }
                    this.timerID = VertxHttpRequest.this.context.owner().setTimer(unit.toMillis(time), v -> this.handleTimeout());
                }
                return true;
            }

            protected void handleTimeout() {
                if (this.timeoutHandler != null) {
                    this.timeoutHandler.handleTimeout(this);
                }
                if (VertxExecutionContext.this.done) {
                    return;
                }
                this.resume(new ServiceUnavailableException());
            }

            private class FlushTask
            implements Consumer<Throwable> {
                private FlushTask() {
                }

                @Override
                public void accept(Throwable t) {
                    try {
                        VertxHttpRequest.this.requestContext.terminate();
                    }
                    finally {
                        VertxHttpAsyncResponse.this.vertxFlush();
                    }
                }
            }
        }
    }
}

