/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.validator;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.Recipient;

public class JobDetailsValidator {
    public static JobDetails validateToCreate(JobDetails job) {
        if (Objects.isNull(job.getPayload()) || StringUtils.isEmpty((CharSequence)job.getId()) || StringUtils.isEmpty((CharSequence)job.getCorrelationId()) || Objects.isNull(job.getTrigger()) || Objects.isNull(job.getRecipient()) || job.getRecipient() instanceof Recipient.HTTPRecipient && StringUtils.isBlank((CharSequence)((Recipient.HTTPRecipient)job.getRecipient()).getEndpoint())) {
            throw new IllegalArgumentException("Invalid Job Attributes. " + job);
        }
        return job;
    }

    public static JobDetails validateToMerge(JobDetails job) {
        if (Objects.nonNull(job.getPayload()) || StringUtils.isNotEmpty((CharSequence)job.getId()) || StringUtils.isNotEmpty((CharSequence)job.getScheduledId()) || StringUtils.isNotEmpty((CharSequence)job.getCorrelationId()) || Objects.nonNull(job.getExecutionCounter()) && job.getExecutionCounter() > 0 || Objects.nonNull(job.getPriority()) || Objects.nonNull(job.getRetries()) && job.getRetries() > 0 || Objects.nonNull(job.getRecipient()) || Objects.nonNull((Object)job.getStatus())) {
            throw new IllegalArgumentException("Merge can only be applied to the Job scheduling trigger attributes for Job. " + job);
        }
        return job;
    }
}

