/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.reactivemessaging.http.runtime.OutgoingHttpMetadata;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.stream.AbstractJobStreams;

@ApplicationScoped
public class KnativeJobStreams
extends AbstractJobStreams {
    public static final String PUBLISH_EVENTS_CONFIG_KEY = "kogito.jobs-service.knative-events";
    public static final String JOB_STATUS_CHANGE_EVENTS_KNATIVE = "kogito-job-service-job-status-events-knative";
    public static final Supplier<OutgoingHttpMetadata> OUTGOING_HTTP_METADATA = () -> new OutgoingHttpMetadata.Builder().addHeader("Content-Type", "application/cloudevents+json").build();

    @Inject
    public KnativeJobStreams(ObjectMapper objectMapper, @ConfigProperty(name="kogito.jobs-service.knative-events") Optional<String> config, @Channel(value="kogito-job-service-job-status-events-knative") @OnOverflow(value=OnOverflow.Strategy.LATEST) Emitter<String> emitter, @ConfigProperty(name="kogito.service.url", defaultValue="http://localhost:8080") String url) {
        super(objectMapper, config.map(Boolean::valueOf).filter(Boolean.TRUE::equals).orElse(false), emitter, url);
    }

    @Override
    @Incoming(value="job-status-change-events")
    @Acknowledgment(value=Acknowledgment.Strategy.PRE_PROCESSING)
    public void jobStatusChange(JobDetails job) {
        super.jobStatusChange(job);
    }

    @Override
    protected Message<String> decorate(Message<String> message) {
        return message.addMetadata((Object)OUTGOING_HTTP_METADATA.get());
    }
}

