/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.error;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.kie.kogito.jobs.service.model.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    public static final int DEFAULT_ERROR_CODE = 500;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean logStackTrace;
    private final int errorCode;

    public BaseExceptionMapper(boolean logStackTrace) {
        this(500, logStackTrace);
    }

    public BaseExceptionMapper(int errorCode, boolean logStackTrace) {
        this.errorCode = errorCode;
        this.logStackTrace = logStackTrace;
    }

    public Response toResponse(T exception) {
        this.log(exception);
        return this.buildResponse(exception, this.errorCode);
    }

    protected Response buildResponse(T exception, int errorCode) {
        return Response.status((int)errorCode).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorResponse(this.errorMessage(exception))).build();
    }

    protected void log(T exception) {
        if (this.logStackTrace) {
            this.logger.error("Handling HTTP Error", exception);
        } else {
            this.logger.error("Handling HTTP Error {}", (Object)((Throwable)exception).getMessage());
        }
    }

    protected String errorMessage(T exception) {
        return ((Throwable)exception).getMessage();
    }
}

