/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.marshaller;

import io.vertx.core.json.JsonObject;
import java.util.Date;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

@ApplicationScoped
public class TriggerMarshaller {
    private static final String CLASS_TYPE = "classType";

    public JsonObject marshall(Trigger trigger) {
        if (trigger instanceof IntervalTrigger) {
            return JsonObject.mapFrom((Object)new IntervalTriggerAccessor((IntervalTrigger)trigger)).put(CLASS_TYPE, (Object)trigger.getClass().getName());
        }
        if (trigger instanceof PointInTimeTrigger) {
            return JsonObject.mapFrom((Object)new PointInTimeTriggerAccessor((PointInTimeTrigger)trigger)).put(CLASS_TYPE, (Object)trigger.getClass().getName());
        }
        return null;
    }

    public Trigger unmarshall(JsonObject jsonObject) {
        String classType = Optional.ofNullable(jsonObject).map(o -> (String)o.remove(CLASS_TYPE)).orElse(null);
        if (IntervalTrigger.class.getName().equals(classType)) {
            return ((IntervalTriggerAccessor)jsonObject.mapTo(IntervalTriggerAccessor.class)).to();
        }
        if (PointInTimeTrigger.class.getName().equals(classType)) {
            return ((PointInTimeTriggerAccessor)jsonObject.mapTo(PointInTimeTriggerAccessor.class)).to();
        }
        return null;
    }

    public static Long toTime(Date date) {
        return Optional.ofNullable(date).map(Date::getTime).orElse(null);
    }

    public static Date toDate(Long time) {
        return Optional.ofNullable(time).map(Date::new).orElse(null);
    }

    private static class IntervalTriggerAccessor {
        private Long startTime;
        private Long endTime;
        private int repeatLimit;
        private int repeatCount;
        private Long nextFireTime;
        private long period;

        public IntervalTriggerAccessor() {
        }

        public IntervalTriggerAccessor(IntervalTrigger trigger) {
            this.startTime = TriggerMarshaller.toTime(trigger.getStartTime());
            this.endTime = TriggerMarshaller.toTime(trigger.getEndTime());
            this.repeatLimit = trigger.getRepeatLimit();
            this.repeatCount = trigger.getRepeatCount();
            this.nextFireTime = TriggerMarshaller.toTime(trigger.getNextFireTime());
            this.period = trigger.getPeriod();
        }

        public IntervalTrigger to() {
            IntervalTrigger intervalTrigger = new IntervalTrigger();
            intervalTrigger.setStartTime(TriggerMarshaller.toDate(this.startTime));
            intervalTrigger.setEndTime(TriggerMarshaller.toDate(this.endTime));
            intervalTrigger.setRepeatLimit(this.repeatLimit);
            intervalTrigger.setRepeatCount(this.repeatCount);
            intervalTrigger.setNextFireTime(TriggerMarshaller.toDate(this.nextFireTime));
            intervalTrigger.setPeriod(this.period);
            return intervalTrigger;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public int getRepeatLimit() {
            return this.repeatLimit;
        }

        public int getRepeatCount() {
            return this.repeatCount;
        }

        public Long getNextFireTime() {
            return this.nextFireTime;
        }

        public long getPeriod() {
            return this.period;
        }
    }

    private static class PointInTimeTriggerAccessor {
        private Long nextFireTime;

        public PointInTimeTriggerAccessor() {
        }

        public PointInTimeTriggerAccessor(PointInTimeTrigger trigger) {
            this.nextFireTime = TriggerMarshaller.toTime(trigger.hasNextFireTime());
        }

        public PointInTimeTrigger to() {
            return Optional.ofNullable(this.nextFireTime).map(t -> new PointInTimeTrigger(t.longValue(), null, null)).orElse(null);
        }

        public Long getNextFireTime() {
            return this.nextFireTime;
        }
    }
}

