/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.marshaller;

import io.vertx.core.json.JsonObject;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.jobs.service.model.job.Recipient;

@ApplicationScoped
public class RecipientMarshaller {
    private static final String CLASS_TYPE = "classType";

    public JsonObject marshall(Recipient recipient) {
        if (recipient instanceof Recipient.HTTPRecipient) {
            return JsonObject.mapFrom((Object)new HTTPRecipientAccessor((Recipient.HTTPRecipient)recipient)).put(CLASS_TYPE, (Object)recipient.getClass().getName());
        }
        return null;
    }

    public Recipient unmarshall(JsonObject jsonObject) {
        String classType = Optional.ofNullable(jsonObject).map(o -> (String)o.remove(CLASS_TYPE)).orElse(null);
        if (Recipient.HTTPRecipient.class.getName().equals(classType)) {
            return ((HTTPRecipientAccessor)jsonObject.mapTo(HTTPRecipientAccessor.class)).to();
        }
        return null;
    }

    static class HTTPRecipientAccessor {
        private String endpoint;

        public HTTPRecipientAccessor() {
        }

        public HTTPRecipientAccessor(Recipient.HTTPRecipient recipient) {
            this.endpoint = recipient.getEndpoint();
        }

        public Recipient.HTTPRecipient to() {
            return new Recipient.HTTPRecipient(this.endpoint);
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }
    }
}

