/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.validator;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.JobDetailsBuilder;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.validator.JobDetailsValidator;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

class JobDetailsValidatorTest {
    private static final String CALLBACK_ENDPOINT = "http://localhost:8080/callback";
    private static final String ID = "id";

    JobDetailsValidatorTest() {
    }

    @Test
    void testValidateSuccess() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).payload((Object)"{\"name\":\"Arthur\"}").recipient((Recipient)new Recipient.HTTPRecipient(CALLBACK_ENDPOINT)).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThat((Object)JobDetailsValidator.validateToCreate((JobDetails)job)).isEqualTo((Object)job);
    }

    @Test
    void testValidateMissingId() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).recipient((Recipient)new Recipient.HTTPRecipient(CALLBACK_ENDPOINT)).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToCreate((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingPayload() {
        JobDetails job = new JobDetailsBuilder().payload((Object)"{\"name\":\"Arthur\"}").recipient((Recipient)new Recipient.HTTPRecipient(CALLBACK_ENDPOINT)).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToCreate((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingRecipientEndpoint() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).payload((Object)"{\"name\":\"Arthur\"}").trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToCreate((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingRecipient() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).payload((Object)"{\"name\":\"Arthur\"}").recipient((Recipient)new Recipient.HTTPRecipient(null)).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToCreate((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingTrigger() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).payload((Object)"{\"name\":\"Arthur\"}").recipient((Recipient)new Recipient.HTTPRecipient(CALLBACK_ENDPOINT)).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToCreate((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateToMergeSuccess() {
        JobDetails job = new JobDetailsBuilder().trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThat((Object)JobDetailsValidator.validateToMerge((JobDetails)job)).isEqualTo((Object)job);
    }

    @Test
    void testValidateToMergeWithId() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToMerge((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateToMergeWithPayload() {
        JobDetails job = new JobDetailsBuilder().payload((Object)"{\"name\":\"Arthur\"}").trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToMerge((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateToMergeWithRecipient() {
        JobDetails job = new JobDetailsBuilder().recipient((Recipient)new Recipient.HTTPRecipient(CALLBACK_ENDPOINT)).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> JobDetailsValidator.validateToMerge((JobDetails)job)).isInstanceOf(IllegalArgumentException.class);
    }
}

