/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.scheduler;

import io.quarkus.runtime.StartupEvent;
import io.vertx.mutiny.core.Vertx;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.management.MessagingChangeEvent;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.JobSchedulerManager;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class JobSchedulerManagerTest {
    public static final String JOB_ID = UUID.randomUUID().toString();
    @Mock
    TimerDelegateJobScheduler scheduler;
    @Mock
    ReactiveJobRepository repository;
    @Mock
    Vertx vertx;
    @Spy
    @InjectMocks
    private JobSchedulerManager tested;
    @Captor
    private ArgumentCaptor<Runnable> captorFirstExecution;
    @Captor
    private ArgumentCaptor<Consumer<Long>> captorPeriodic;
    private JobDetails scheduledJob;

    JobSchedulerManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.scheduledJob = JobDetails.builder().id(JOB_ID).trigger((Trigger)new PointInTimeTrigger(System.currentTimeMillis(), null, null)).build();
        Mockito.lenient().when((Object)this.repository.findByStatusBetweenDatesOrderByPriority((ZonedDateTime)ArgumentMatchers.any(ZonedDateTime.class), (ZonedDateTime)ArgumentMatchers.any(ZonedDateTime.class), new JobStatus[]{(JobStatus)ArgumentMatchers.any(JobStatus.class), (JobStatus)ArgumentMatchers.any(JobStatus.class)})).thenReturn((Object)ReactiveStreams.of((Object)this.scheduledJob));
        Mockito.lenient().when((Object)this.scheduler.scheduled(JOB_ID)).thenReturn(Optional.empty());
        Mockito.lenient().when((Object)this.scheduler.schedule(this.scheduledJob)).thenReturn((Object)ReactiveStreams.of((Object)this.scheduledJob).buildRs());
        this.tested.onMessagingStatusChange(new MessagingChangeEvent(true));
    }

    @Test
    void testOnStartup(@Mock StartupEvent event) {
        this.tested.onStartup(event);
        ((Vertx)Mockito.verify((Object)this.vertx)).runOnContext((Runnable)this.captorFirstExecution.capture());
        ((Vertx)Mockito.verify((Object)this.vertx)).setPeriodic(ArgumentMatchers.eq((long)this.tested.loadJobIntervalInMinutes), (Consumer)this.captorPeriodic.capture());
    }

    @Test
    void testOnStartupInvalidInterval(@Mock StartupEvent event) {
        this.tested.schedulerChunkInMinutes = 10L;
        this.tested.loadJobIntervalInMinutes = 20L;
        this.tested.onStartup(event);
        Assertions.assertThat((long)this.tested.loadJobIntervalInMinutes).isEqualTo(this.tested.schedulerChunkInMinutes);
    }

    @Test
    void testLoadJobDetailss() {
        this.tested.loadJobDetails();
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler)).schedule(this.scheduledJob);
    }

    @Test
    void testLoadAlreadyJobDetailss() {
        Mockito.when((Object)this.scheduler.scheduled(JOB_ID)).thenReturn(Optional.of(DateUtil.now()));
        this.tested.loadJobDetails();
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.never())).schedule(this.scheduledJob);
    }
}

