/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.scheduler;

import io.smallrye.mutiny.Multi;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.executor.JobExecutor;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.ManageableJobHandle;
import org.kie.kogito.jobs.service.model.job.ScheduledJobAdapter;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.BaseTimerJobScheduler;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Publisher;

public abstract class BaseTimerJobSchedulerTest {
    public static final String JOB_ID = UUID.randomUUID().toString();
    public static final String SCHEDULED_ID = "3";
    @Mock
    public JobExecutor jobExecutor;
    @Mock
    public ReactiveJobRepository jobRepository;
    public CompletionStage<JobDetails> scheduled;
    @Captor
    private ArgumentCaptor<Optional<Trigger>> delayCaptor;
    @Captor
    private ArgumentCaptor<JobDetails> scheduleCaptor;
    @Captor
    private ArgumentCaptor<CompletionStage<JobDetails>> scheduleCaptorFuture;
    public JobDetails scheduledJob;
    public JobExecutionResponse errorResponse;
    public ZonedDateTime expirationTime;
    public Trigger trigger;

    @BeforeEach
    public void setUp() {
        this.tested().schedulerChunkInMinutes = 5L;
        this.tested().forceExecuteExpiredJobs = Optional.of(Boolean.FALSE);
        this.expirationTime = DateUtil.now().plusMinutes(this.tested().schedulerChunkInMinutes - 1L);
        this.trigger = new PointInTimeTrigger(this.expirationTime.toInstant().toEpochMilli(), null, null);
        this.scheduledJob = JobDetails.builder().id(JOB_ID).trigger(this.trigger).status(JobStatus.SCHEDULED).build();
        this.scheduled = CompletableFuture.completedFuture(this.scheduledJob);
        Mockito.lenient().when((Object)this.jobRepository.get(JOB_ID)).thenReturn(this.scheduled);
        Mockito.lenient().when((Object)this.jobRepository.save((JobDetails)ArgumentMatchers.any(JobDetails.class))).thenAnswer(a -> CompletableFuture.completedFuture(a.getArgument(0)));
        Mockito.lenient().when((Object)this.jobExecutor.execute((CompletionStage)ArgumentMatchers.any())).thenReturn(this.scheduled);
        this.errorResponse = JobExecutionResponse.builder().jobId(JOB_ID).message("error").now().build();
    }

    public abstract BaseTimerJobScheduler tested();

    @Test
    void testScheduleNotExistingJob() {
        Mockito.when((Object)this.jobRepository.exists(JOB_ID)).thenReturn(CompletableFuture.completedFuture(false));
        Publisher schedule = this.tested().schedule(this.scheduledJob);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        this.subscribeOn((Publisher<JobDetails>)schedule);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository)).save((JobDetails)this.scheduleCaptor.capture());
        JobDetails scheduledJob = (JobDetails)this.scheduleCaptor.getValue();
        Assertions.assertThat((String)scheduledJob.getScheduledId()).isEqualTo(SCHEDULED_ID);
        Assertions.assertThat((String)scheduledJob.getId()).isEqualTo(JOB_ID);
        Assertions.assertThat((Comparable)scheduledJob.getStatus()).isEqualTo((Object)JobStatus.SCHEDULED);
    }

    @Test
    void testScheduleExistingJob() {
        this.testExistingJob(false, JobStatus.SCHEDULED);
    }

    @Test
    void testScheduleExistingJobExpired() {
        this.testExistingJob(true, JobStatus.SCHEDULED);
    }

    private void testExistingJob(boolean expired, JobStatus jobStatus) {
        this.scheduledJob = Optional.of(expired).filter(Boolean.TRUE::equals).map(e -> JobDetails.builder().status(jobStatus).id(JOB_ID).trigger((Trigger)new PointInTimeTrigger(System.currentTimeMillis() - 1L, null, null)).build()).orElse(JobDetails.builder().of(this.scheduledJob).status(jobStatus).build());
        Mockito.when((Object)this.jobRepository.exists(JOB_ID)).thenReturn(CompletableFuture.completedFuture(true));
        CompletableFuture<JobDetails> scheduledJobCompletableFuture = CompletableFuture.completedFuture(this.scheduledJob);
        Mockito.lenient().when((Object)this.jobRepository.delete(JOB_ID)).thenReturn(scheduledJobCompletableFuture);
        Mockito.lenient().when((Object)this.jobRepository.delete((JobDetails)ArgumentMatchers.any(JobDetails.class))).thenReturn(scheduledJobCompletableFuture);
        Mockito.lenient().when((Object)this.jobRepository.get(JOB_ID)).thenReturn(scheduledJobCompletableFuture);
        Publisher schedule = this.tested().schedule(this.scheduledJob);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        this.subscribeOn((Publisher<JobDetails>)schedule);
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository, (VerificationMode)(expired || JobStatus.SCHEDULED.equals((Object)jobStatus) ? Mockito.atLeastOnce() : Mockito.never()))).delete((JobDetails)ArgumentMatchers.any(JobDetails.class));
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)(expired ? Mockito.never() : Mockito.times((int)1)))).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository, (VerificationMode)(expired ? Mockito.never() : Mockito.times((int)1)))).save((JobDetails)this.scheduleCaptor.capture());
        Optional.ofNullable(jobStatus).filter(arg_0 -> JobStatus.SCHEDULED.equals(arg_0)).ifPresent(s -> {
            ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).cancel((CompletionStage)this.scheduleCaptorFuture.capture());
            try {
                JobDetails value = (JobDetails)((CompletionStage)this.scheduleCaptorFuture.getValue()).toCompletableFuture().get(1L, TimeUnit.MILLISECONDS);
                Assertions.assertThat((String)value.getId()).isEqualTo(this.scheduledJob.getId());
                Assertions.assertThat((Comparable)value.getStatus()).isEqualTo((Object)JobStatus.CANCELED);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (!expired) {
            JobDetails returnedJobDetails = (JobDetails)this.scheduleCaptor.getValue();
            Assertions.assertThat((String)returnedJobDetails.getScheduledId()).isEqualTo(SCHEDULED_ID);
            Assertions.assertThat((String)returnedJobDetails.getId()).isEqualTo(JOB_ID);
            Assertions.assertThat((Comparable)returnedJobDetails.getStatus()).isEqualTo((Object)this.scheduledJob.getStatus());
        }
    }

    @Test
    void testScheduleExistingJobRetryExpired() {
        this.testExistingJob(true, JobStatus.RETRY);
    }

    @Test
    void testScheduleExistingJobRetry() {
        this.testExistingJob(false, JobStatus.RETRY);
    }

    @Test
    void testScheduleExistingJobPeriodic() {
        this.scheduledJob = this.createPeriodicJob();
        this.testExistingJob(false, JobStatus.SCHEDULED);
    }

    @Test
    void testHandleJobExecutionSuccess() {
        PublisherBuilder executionSuccess = this.tested().handleJobExecutionSuccess(this.scheduledJob);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).cancel((CompletionStage)this.scheduleCaptorFuture.capture());
        this.subscribeOn((Publisher<JobDetails>)executionSuccess.buildRs());
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).cancel((CompletionStage)this.scheduleCaptorFuture.capture());
    }

    @Test
    void testHandleJobExecutionSuccessPeriodicFirstExecution() {
        this.scheduledJob = this.createPeriodicJob();
        PublisherBuilder executionSuccess = this.tested().handleJobExecutionSuccess(this.scheduledJob);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).cancel((CompletionStage)this.scheduleCaptorFuture.capture());
        this.subscribeOn((Publisher<JobDetails>)executionSuccess.buildRs());
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).doSchedule((JobDetails)this.scheduleCaptor.capture(), (Optional)this.delayCaptor.capture());
    }

    private JobDetails createPeriodicJob() {
        return JobDetails.builder().id(JOB_ID).trigger((Trigger)ScheduledJobAdapter.intervalTrigger((ZonedDateTime)this.expirationTime, (int)10, (int)2)).status(JobStatus.SCHEDULED).build();
    }

    @Test
    void testHandleJobExecutionSuccessPeriodic() {
        this.scheduledJob = this.createPeriodicJob();
        PublisherBuilder executionSuccess = this.tested().handleJobExecutionSuccess(this.scheduledJob);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).cancel((CompletionStage)this.scheduleCaptorFuture.capture());
        this.subscribeOn((Publisher<JobDetails>)executionSuccess.buildRs());
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository, (VerificationMode)Mockito.times((int)2))).save((JobDetails)this.scheduleCaptor.capture());
        JobDetails scheduleCaptorValue = (JobDetails)this.scheduleCaptor.getValue();
        Assertions.assertThat((Comparable)scheduleCaptorValue.getStatus()).isEqualTo((Object)JobStatus.SCHEDULED);
        Assertions.assertThat((Integer)scheduleCaptorValue.getExecutionCounter()).isEqualTo(1);
    }

    @Test
    void testHandleJobExecutionErrorWithRetry() {
        PublisherBuilder scheduledJobPublisher = this.tested().handleJobExecutionError(this.errorResponse);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        this.subscribeOn((Publisher<JobDetails>)scheduledJobPublisher.buildRs());
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository)).save((JobDetails)this.scheduleCaptor.capture());
        JobDetails saved = (JobDetails)this.scheduleCaptor.getValue();
        Assertions.assertThat((Comparable)saved.getStatus()).isEqualTo((Object)JobStatus.RETRY);
    }

    @Test
    void testHandleJobExecutionErrorFinal() {
        this.scheduledJob = JobDetails.builder().of(this.scheduledJob).status(JobStatus.ERROR).build();
        Mockito.when((Object)this.jobRepository.get(JOB_ID)).thenReturn(CompletableFuture.completedFuture(this.scheduledJob));
        PublisherBuilder scheduledJobPublisher = this.tested().handleJobExecutionError(this.errorResponse);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        this.subscribeOn((Publisher<JobDetails>)scheduledJobPublisher.buildRs());
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
    }

    protected <T> Consumer<T> dummyCallback() {
        return t -> {};
    }

    @Test
    void testCancel() {
        this.tested().cancel(JOB_ID);
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository)).get(JOB_ID);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).cancel((CompletionStage)this.scheduleCaptorFuture.capture());
        ((CompletionStage)this.scheduleCaptorFuture.getValue()).thenAccept(j -> Assertions.assertThat((Comparable)j.getStatus()).isEqualTo((Object)JobStatus.CANCELED));
    }

    @Test
    void testCancelJobDetails() {
        this.scheduledJob = JobDetails.builder().of(this.scheduledJob).status(JobStatus.SCHEDULED).scheduledId("1").build();
        Mockito.when((Object)this.tested().doCancel(this.scheduledJob)).thenReturn((Object)ReactiveStreams.of((Object)new ManageableJobHandle(true)).buildRs());
        this.tested().cancel(CompletableFuture.completedFuture(this.scheduledJob));
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).doCancel(this.scheduledJob);
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository)).delete(this.scheduledJob);
    }

    @Test
    void testCancelNotJobDetails() {
        this.tested().cancel(this.scheduled);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doCancel(this.scheduledJob);
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository)).delete(this.scheduledJob);
    }

    @Test
    void testScheduleOutOfCurrentChunk() {
        this.expirationTime = DateUtil.now().plusMinutes(this.tested().schedulerChunkInMinutes + 10L);
        this.scheduledJob = JobDetails.builder().of(this.scheduledJob).trigger((Trigger)new PointInTimeTrigger(this.expirationTime.toInstant().toEpochMilli(), null, null)).build();
        Mockito.when((Object)this.jobRepository.exists((String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.FALSE));
        this.subscribeOn((Publisher<JobDetails>)this.tested().schedule(this.scheduledJob));
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository)).save((JobDetails)this.scheduleCaptor.capture());
        JobDetails current = (JobDetails)this.scheduleCaptor.getValue();
        Assertions.assertThat((String)current.getId()).isEqualTo(JOB_ID);
        Assertions.assertThat((Comparable)current.getStatus()).isEqualTo((Object)JobStatus.SCHEDULED);
        Assertions.assertThat((String)current.getScheduledId()).isNull();
    }

    @Test
    void testScheduleInCurrentChunk() {
        Mockito.when((Object)this.jobRepository.exists((String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.FALSE));
        this.subscribeOn((Publisher<JobDetails>)this.tested().schedule(this.scheduledJob));
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        ((ReactiveJobRepository)Mockito.verify((Object)this.jobRepository)).save((JobDetails)this.scheduleCaptor.capture());
        JobDetails current = (JobDetails)this.scheduleCaptor.getValue();
        Assertions.assertThat((String)current.getId()).isEqualTo(JOB_ID);
        Assertions.assertThat((Comparable)current.getStatus()).isEqualTo((Object)JobStatus.SCHEDULED);
        Assertions.assertThat((String)current.getScheduledId()).isNotNull();
    }

    @Test
    void testScheduled() {
        this.testExistingJob(false, JobStatus.SCHEDULED);
        Optional scheduled = this.tested().scheduled(JOB_ID);
        ((OptionalAssert)Assertions.assertThat((Optional)scheduled).isNotNull()).isPresent();
    }

    private void subscribeOn(Publisher<JobDetails> schedule) {
        Multi.createFrom().publisher(schedule).subscribe().with(this.dummyCallback(), this.dummyCallback());
    }

    @Test
    void testForceExpiredJobToBeExecuted() {
        Mockito.when((Object)this.jobRepository.exists((String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.FALSE));
        this.scheduledJob = JobDetails.builder().of(this.scheduledJob).trigger((Trigger)ScheduledJobAdapter.intervalTrigger((ZonedDateTime)DateUtil.now().minusHours(1L), (int)1, (int)1)).build();
        this.subscribeOn((Publisher<JobDetails>)this.tested().schedule(this.scheduledJob));
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.never())).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
        this.tested().forceExecuteExpiredJobs = Optional.of(Boolean.TRUE);
        this.subscribeOn((Publisher<JobDetails>)this.tested().schedule(this.scheduledJob));
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested(), (VerificationMode)Mockito.times((int)1))).doSchedule((JobDetails)ArgumentMatchers.eq((Object)this.scheduledJob), (Optional)this.delayCaptor.capture());
    }

    @Test
    void testRescheduleAndMerge() {
        ZonedDateTime newTime = DateUtil.now().plusMinutes(1L);
        PointInTimeTrigger newTrigger = new PointInTimeTrigger(newTime.toInstant().toEpochMilli(), null, null);
        JobDetails jobToMerge = JobDetails.builder().trigger((Trigger)newTrigger).build();
        JobDetails merged = JobDetails.builder().of(this.scheduledJob).merge(jobToMerge).build();
        Mockito.when((Object)this.jobRepository.merge(JOB_ID, jobToMerge)).thenReturn(CompletableFuture.completedFuture(merged));
        this.subscribeOn((Publisher<JobDetails>)this.tested().reschedule(JOB_ID, (Trigger)newTrigger).buildRs());
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).doCancel(merged);
        ((BaseTimerJobScheduler)Mockito.verify((Object)this.tested())).schedule(merged);
    }
}

