/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.AccessTokenResponse;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.utils.DateUtil;

public abstract class BaseKeycloakJobServiceIT {
    public static final int OK_CODE = 200;
    public static final int UNAUTHORIZED_CODE = 403;
    public static final int FORBIDDEN_CODE = 401;
    @ConfigProperty(name="quarkus.oidc.auth-server-url")
    private String keycloakURL;
    @Inject
    private ObjectMapper objectMapper;

    @BeforeAll
    public static void setup() throws Exception {
        System.setProperty("quarkus.http.auth.policy.role-policy1.roles-allowed", "confidential");
        System.setProperty("quarkus.http.auth.permission.roles1.paths", "/*");
        System.setProperty("quarkus.http.auth.permission.roles1.policy", "role-policy1");
    }

    @BeforeEach
    public void init() throws Exception {
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).get("/q/health", new Object[0])).then()).statusCode(200));
    }

    @Test
    void create() throws Exception {
        Job job = this.getJob("1");
        this.createJob(this.jobToJson(job), this.getAccessToken("alice"), 403);
        this.createJob(this.jobToJson(job), "", 401);
        ScheduledJob response = (ScheduledJob)this.createJob(this.jobToJson(job), this.getAccessToken("jdoe"), 200).extract().as(ScheduledJob.class);
        Assertions.assertEquals((Object)job, (Object)response);
    }

    private ValidatableResponse createJob(String body, String token, int statusCode) throws IOException {
        RequestSpecification requestSpecification = RestAssured.given();
        if (token != null && !token.isEmpty()) {
            requestSpecification = requestSpecification.given().auth().oauth2(token);
        }
        return (ValidatableResponse)((ValidatableResponse)((Response)requestSpecification.contentType(ContentType.JSON).body(body).when().post("/jobs", new Object[0])).then()).statusCode(statusCode);
    }

    private String jobToJson(Job job) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)job);
    }

    private Job getJob(String id) {
        return JobBuilder.builder().id(id).expirationTime(DateUtil.now().plusSeconds(10L)).callbackEndpoint("http://localhost:8081/callback").processId("processId").processInstanceId("processInstanceId").rootProcessId("rootProcessId").rootProcessInstanceId("rootProcessInstanceId").nodeInstanceId("nodeInstanceId").priority(Integer.valueOf(1)).build();
    }

    @Test
    void deleteAfterCreate() throws Exception {
        String id = "2";
        Job job = this.getJob("2");
        this.createJob(this.jobToJson(job), this.getAccessToken("alice"), 403);
        this.createJob(this.jobToJson(job), "", 401);
        this.createJob(this.jobToJson(job), this.getAccessToken("jdoe"), 200);
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)"2").when().delete("/jobs/{id}", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("alice")).pathParam("id", (Object)"2").when().delete("/jobs/{id}", new Object[0])).then()).statusCode(403);
        ScheduledJob response = (ScheduledJob)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).pathParam("id", (Object)"2").when().delete("/jobs/{id}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().as(ScheduledJob.class);
        Assertions.assertEquals((Object)job, (Object)response);
    }

    @Test
    void getAfterCreate() throws Exception {
        String id = "3";
        Job job = this.getJob("3");
        this.createJob(this.jobToJson(job), this.getAccessToken("jdoe"), 200);
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)"3").when().get("/jobs/{id}", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("alice")).pathParam("id", (Object)"3").when().get("/jobs/{id}", new Object[0])).then()).statusCode(403);
        ScheduledJob scheduledJob = (ScheduledJob)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).pathParam("id", (Object)"3").when().get("/jobs/{id}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).assertThat()).extract().as(ScheduledJob.class);
        Assertions.assertEquals((Object)scheduledJob.getId(), (Object)job.getId());
    }

    @Test
    void executeTest() throws Exception {
        String id = "4";
        Job job = this.getJob("4");
        this.createJob(this.jobToJson(job), this.getAccessToken("jdoe"), 200);
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)"4").when().get("/jobs/{id}", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("alice")).pathParam("id", (Object)"4").when().get("/jobs/{id}", new Object[0])).then()).statusCode(403);
        ScheduledJob scheduledJob = (ScheduledJob)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).pathParam("id", (Object)"4").when().get("/jobs/{id}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).assertThat()).extract().as(ScheduledJob.class);
        Assertions.assertEquals((Object)scheduledJob.getId(), (Object)job.getId());
        Assertions.assertEquals((int)0, (Integer)scheduledJob.getRetries());
        Assertions.assertEquals((Object)JobStatus.SCHEDULED, (Object)scheduledJob.getStatus());
        Assertions.assertNotNull((Object)scheduledJob.getScheduledId());
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{"kogito-app"}).param("client_secret", new Object[]{"secret"}).when().post(this.keycloakURL + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

