/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.marshaller;

import io.vertx.core.json.JsonObject;
import java.time.ZonedDateTime;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.repository.marshaller.JobDetailsMarshaller;
import org.kie.kogito.jobs.service.repository.marshaller.RecipientMarshaller;
import org.kie.kogito.jobs.service.repository.marshaller.TriggerMarshaller;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

class JobDetailsMarshallerTest {
    JobDetailsMarshaller jobDetailsMarshaller;
    JobDetails jobDetails;
    JsonObject jsonObject;

    JobDetailsMarshallerTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobDetailsMarshaller = new JobDetailsMarshaller(new TriggerMarshaller(), new RecipientMarshaller());
        String id = "testId";
        String correlationId = "testCorrelationId";
        JobStatus status = JobStatus.SCHEDULED;
        Date date = new Date();
        ZonedDateTime lastUpdate = ZonedDateTime.ofInstant(date.toInstant(), DateUtil.DEFAULT_ZONE);
        Integer retries = 2;
        Integer priority = 3;
        Integer executionCounter = 4;
        String scheduledId = "testScheduledId";
        JsonObject payload = new JsonObject().put("payload", (Object)"test");
        Recipient.HTTPRecipient recipient = new Recipient.HTTPRecipient("testEndpoint");
        PointInTimeTrigger trigger = new PointInTimeTrigger(new Date().toInstant().toEpochMilli(), null, null);
        JobDetails.Type type = JobDetails.Type.HTTP;
        this.jobDetails = JobDetails.builder().id(id).correlationId(correlationId).status(status).lastUpdate(lastUpdate).retries(retries).executionCounter(executionCounter).scheduledId(scheduledId).payload((Object)payload).type(type).priority(priority).recipient((Recipient)recipient).trigger((Trigger)trigger).build();
        this.jsonObject = new JsonObject().put("id", (Object)id).put("correlationId", (Object)correlationId).put("status", (Object)status.name()).put("lastUpdate", (Object)date.getTime()).put("retries", (Object)retries).put("executionCounter", (Object)executionCounter).put("scheduledId", (Object)scheduledId).put("payload", (Object)payload).put("type", (Object)type.name()).put("priority", (Object)priority).put("recipient", (Object)new JsonObject().put("endpoint", (Object)recipient.getEndpoint()).put("classType", (Object)Recipient.HTTPRecipient.class.getName())).put("trigger", (Object)new JsonObject().put("nextFireTime", (Object)trigger.hasNextFireTime().getTime()).put("classType", (Object)PointInTimeTrigger.class.getName()));
    }

    @Test
    void marshall() {
        Assertions.assertEquals((Object)this.jsonObject, (Object)this.jobDetailsMarshaller.marshall(this.jobDetails));
    }

    @Test
    void marshallNull() {
        Assertions.assertNull((Object)this.jobDetailsMarshaller.marshall(null));
    }

    @Test
    void unmarshall() {
        Assertions.assertEquals((Object)this.jobDetails, (Object)this.jobDetailsMarshaller.unmarshall(this.jsonObject));
    }

    @Test
    void unmarshallNull() {
        Assertions.assertNull((Object)this.jobDetailsMarshaller.unmarshall(null));
    }
}

