/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.impl;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.stream.JobStreams;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.jobs.service.utils.FunctionsUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class BaseJobRepositoryTest {
    public static final String ID = UUID.randomUUID().toString();
    private JobDetails job;

    @BeforeEach
    public void setUp() throws Exception {
        this.createAndSaveJob(ID);
    }

    public JobStreams mockJobStreams() {
        JobStreams mock = (JobStreams)Mockito.mock(JobStreams.class);
        Mockito.lenient().when((Object)mock.publishJobStatusChange((JobDetails)ArgumentMatchers.any(JobDetails.class))).thenAnswer(a -> a.getArgument(0));
        Mockito.lenient().when((Object)mock.publishJobSuccess((JobExecutionResponse)ArgumentMatchers.any(JobExecutionResponse.class))).thenAnswer(a -> a.getArgument(0));
        Mockito.lenient().when((Object)mock.publishJobError((JobExecutionResponse)ArgumentMatchers.any(JobExecutionResponse.class))).thenAnswer(a -> a.getArgument(0));
        return mock;
    }

    public abstract ReactiveJobRepository tested();

    @Test
    void testSaveAndGet() throws ExecutionException, InterruptedException {
        JobDetails scheduledJob = (JobDetails)this.tested().get(ID).toCompletableFuture().get();
        Assertions.assertThat((Object)scheduledJob).isEqualTo((Object)this.job);
        JobDetails notFound = (JobDetails)this.tested().get(UUID.randomUUID().toString()).toCompletableFuture().get();
        Assertions.assertThat((Object)notFound).isNull();
    }

    private void createAndSaveJob(String id) throws Exception {
        this.job = JobDetails.builder().id(id).trigger((Trigger)new PointInTimeTrigger(System.currentTimeMillis(), null, null)).priority(Integer.valueOf(1)).recipient((Recipient)new Recipient.HTTPRecipient("url")).build();
        this.tested().save(this.job).toCompletableFuture().get();
    }

    @Test
    void testExists() throws ExecutionException, InterruptedException {
        Boolean exists = (Boolean)this.tested().exists(ID).toCompletableFuture().get();
        Assertions.assertThat((Boolean)exists).isTrue();
        Boolean notFound = (Boolean)this.tested().exists(UUID.randomUUID().toString()).toCompletableFuture().get();
        Assertions.assertThat((Boolean)notFound).isFalse();
    }

    @Test
    void testDelete() throws ExecutionException, InterruptedException {
        JobDetails scheduledJob = (JobDetails)this.tested().delete(ID).toCompletableFuture().get();
        Assertions.assertThat((Object)scheduledJob).isEqualTo((Object)this.job);
        JobDetails notFound = (JobDetails)this.tested().get(ID).toCompletableFuture().get();
        Assertions.assertThat((Object)notFound).isNull();
    }

    @Test
    void testFindAll() throws ExecutionException, InterruptedException {
        List jobs = (List)this.tested().findAll().toList().run().toCompletableFuture().get();
        Assertions.assertThat((int)jobs.size()).isEqualTo(1);
        Assertions.assertThat((Object)((JobDetails)jobs.get(0))).isEqualTo((Object)this.job);
    }

    @Test
    void testFindByStatusBetweenDates() throws ExecutionException, InterruptedException {
        List jobs = IntStream.rangeClosed(1, 10).boxed().map(id -> JobDetails.builder().status(JobStatus.SCHEDULED).id(String.valueOf(id)).priority(id).payload((Object)"{\"payload\": \"test\"}").trigger((Trigger)new PointInTimeTrigger(DateUtil.now().plusMinutes(id.intValue()).toInstant().toEpochMilli(), null, null)).priority(id).build()).peek(j -> FunctionsUtil.unchecked(t -> (JobDetails)this.tested().save(j).toCompletableFuture().get()).apply(null)).collect(Collectors.toList());
        List fetched = (List)this.tested().findByStatusBetweenDatesOrderByPriority(DateUtil.now(), DateUtil.now().plusMinutes(5L).plusSeconds(1L), new JobStatus[]{JobStatus.SCHEDULED}).toList().run().toCompletableFuture().get();
        Assertions.assertThat((int)fetched.size()).isEqualTo(5);
        IntStream.rangeClosed(0, 4).forEach(i -> Assertions.assertThat((Object)((JobDetails)fetched.get(i))).isEqualTo(jobs.get(fetched.size() - 1 - i)));
        List fetchedNotFound = (List)this.tested().findByStatusBetweenDatesOrderByPriority(DateUtil.now(), DateUtil.now().plusMinutes(5L).plusSeconds(1L), new JobStatus[]{JobStatus.CANCELED}).toList().run().toCompletableFuture().get();
        Assertions.assertThat((int)fetchedNotFound.size()).isZero();
        fetchedNotFound = (List)this.tested().findByStatusBetweenDatesOrderByPriority(DateUtil.now().plusDays(1L), DateUtil.now().plusDays(2L), new JobStatus[]{JobStatus.SCHEDULED}).toList().run().toCompletableFuture().get();
        Assertions.assertThat((int)fetchedNotFound.size()).isZero();
    }

    @Test
    void testMergeCallbackEndpoint() throws Exception {
        String id = UUID.randomUUID().toString();
        this.createAndSaveJob(id);
        String newCallbackEndpoint = "http://localhost/newcallback";
        Recipient.HTTPRecipient recipient = new Recipient.HTTPRecipient("http://localhost/newcallback");
        JobDetails toMerge = JobDetails.builder().id(id).recipient((Recipient)recipient).build();
        JobDetails merged = (JobDetails)this.tested().merge(id, toMerge).toCompletableFuture().get();
        Assertions.assertThat((Object)merged.getRecipient()).isEqualTo((Object)recipient);
        Assertions.assertThat((String)merged.getId()).isEqualTo(this.job.getId());
        Assertions.assertThat((Date)merged.getTrigger().hasNextFireTime()).isEqualTo((Object)this.job.getTrigger().hasNextFireTime());
    }
}

