/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model.job;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.JobDetailsBuilder;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.model.job.ScheduledJobAdapter;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;

class ScheduledJobAdapterTest {
    public static final String ENDPOINT = "url";
    public static final String ID = UUID.randomUUID().toString();
    public static final String SCHEDULED_ID = "scheduledId";
    public static final int RETRIES = 10;
    public static final int COUNTER = 5;
    public static final ZonedDateTime LAST_UPDATE = DateUtil.now().minusMinutes(1L);
    public static final int PRIORITY = 2;
    public static final JobStatus STATUS = JobStatus.SCHEDULED;
    public static final ZonedDateTime TIME = DateUtil.now().plusMinutes(5L);
    public static final int REPEAT_LIMIT = 50;
    public static final long INTERVAL = 500L;
    public static final String ROOT_PROCESS_INSTANCE_ID = "ID";
    public static final String ROOT_PROCESS_ID = "";
    public static final String PROCESS_ID = "ID";
    public static final String PROCESS_INSTANCE_ID = "ID";
    private static final String NODE_INSTANCE_ID = "nodeId";
    public static String payload;

    ScheduledJobAdapterTest() {
    }

    @BeforeAll
    public static void before() throws Exception {
        payload = new ObjectMapper().writeValueAsString((Object)new ScheduledJobAdapter.ProcessPayload("ID", "ID", "ID", ROOT_PROCESS_ID, NODE_INSTANCE_ID));
    }

    @Test
    void testOfJobDetailsPointInTime() {
        JobDetails jobDetails = this.getJobDetailsCommonBuilder().trigger((Trigger)new PointInTimeTrigger(TIME.toInstant().toEpochMilli(), null, null)).build();
        ScheduledJob scheduledJob = ScheduledJobAdapter.of((JobDetails)jobDetails);
        this.assertScheduledJob(scheduledJob);
        Assertions.assertThat((Integer)scheduledJob.getRepeatLimit()).isNull();
        Assertions.assertThat((Long)scheduledJob.getRepeatInterval()).isNull();
    }

    @Test
    void testOfJobDetailsInterval() {
        JobDetails jobDetails = this.getJobDetailsCommonBuilder().trigger((Trigger)new IntervalTrigger(0L, DateUtil.toDate((ZonedDateTime)TIME), null, 50, 0L, 500L, null, null)).build();
        ScheduledJob scheduledJob = ScheduledJobAdapter.of((JobDetails)jobDetails);
        this.assertScheduledJob(scheduledJob);
        Assertions.assertThat((Integer)scheduledJob.getRepeatLimit()).isEqualTo(51);
        Assertions.assertThat((Long)scheduledJob.getRepeatInterval()).isEqualTo(500L);
    }

    @Test
    void testToJobDetailsInterval() {
        JobBuilder jobBuilder = JobBuilder.builder().repeatLimit(Integer.valueOf(50)).repeatInterval(Long.valueOf(500L));
        ScheduledJob scheduledJob = this.getScheduledJobCommonBuilder(jobBuilder).build();
        JobDetails jobDetails = ScheduledJobAdapter.to((ScheduledJob)scheduledJob);
        this.assertJobDetails(jobDetails);
        Assertions.assertThat((Object)jobDetails.getTrigger()).isInstanceOf(IntervalTrigger.class);
        IntervalTrigger intervalTrigger = (IntervalTrigger)jobDetails.getTrigger();
        Assertions.assertThat((Date)intervalTrigger.getNextFireTime()).isEqualTo((Object)DateUtil.toDate((ZonedDateTime)TIME));
        Assertions.assertThat((int)intervalTrigger.getRepeatLimit()).isEqualTo(51);
        Assertions.assertThat((long)intervalTrigger.getPeriod()).isEqualTo(500L);
    }

    @Test
    void testToJobDetailsPointInTIme() {
        ScheduledJob scheduledJob = this.getScheduledJobCommonBuilder(JobBuilder.builder()).build();
        JobDetails jobDetails = ScheduledJobAdapter.to((ScheduledJob)scheduledJob);
        this.assertJobDetails(jobDetails);
        Assertions.assertThat((Object)jobDetails.getTrigger()).isInstanceOf(PointInTimeTrigger.class);
        PointInTimeTrigger trigger = (PointInTimeTrigger)jobDetails.getTrigger();
        Assertions.assertThat((Date)trigger.nextFireTime()).isEqualTo((Object)DateUtil.toDate((ZonedDateTime)TIME));
    }

    @Test
    void testToJobDetailsWithEmptyPayload() {
        ScheduledJob scheduledJob = ScheduledJob.builder().job(JobBuilder.builder().id(UUID.randomUUID().toString()).build()).build();
        JobDetails jobDetails = ScheduledJobAdapter.to((ScheduledJob)scheduledJob);
        Assertions.assertThat((Object)jobDetails.getPayload()).isNull();
    }

    @Test
    void testToScheduledJobWithEmptyPayload() {
        JobDetails jobDetails = JobDetails.builder().id(UUID.randomUUID().toString()).build();
        ScheduledJob scheduledJob = ScheduledJobAdapter.of((JobDetails)jobDetails);
        Assertions.assertThat((String)scheduledJob.getProcessId()).isNull();
        Assertions.assertThat((String)scheduledJob.getProcessInstanceId()).isNull();
        Assertions.assertThat((String)scheduledJob.getRootProcessId()).isNull();
        Assertions.assertThat((String)scheduledJob.getRootProcessInstanceId()).isNull();
    }

    private ScheduledJob.ScheduledJobBuilder getScheduledJobCommonBuilder(JobBuilder jobBuilder) {
        return ScheduledJob.builder().job(jobBuilder.id(ID).priority(Integer.valueOf(2)).expirationTime(TIME).callbackEndpoint(ENDPOINT).rootProcessId(ROOT_PROCESS_ID).rootProcessInstanceId("ID").processId("ID").processInstanceId("ID").nodeInstanceId(NODE_INSTANCE_ID).build()).executionCounter(Integer.valueOf(5)).retries(Integer.valueOf(10)).scheduledId(SCHEDULED_ID).status(STATUS).lastUpdate(LAST_UPDATE);
    }

    private JobDetailsBuilder getJobDetailsCommonBuilder() {
        return JobDetails.builder().id(ID).priority(Integer.valueOf(2)).recipient((Recipient)new Recipient.HTTPRecipient(ENDPOINT)).scheduledId(SCHEDULED_ID).type(JobDetails.Type.HTTP).status(STATUS).correlationId(ID).lastUpdate(LAST_UPDATE).executionCounter(Integer.valueOf(5)).priority(Integer.valueOf(2)).retries(Integer.valueOf(10)).payload((Object)payload);
    }

    private void assertScheduledJob(ScheduledJob scheduledJob) {
        Assertions.assertThat((String)scheduledJob.getId()).isEqualTo(ID);
        Assertions.assertThat((String)scheduledJob.getScheduledId()).isEqualTo(SCHEDULED_ID);
        Assertions.assertThat((Integer)scheduledJob.getRetries()).isEqualTo(10);
        Assertions.assertThat((Integer)scheduledJob.getExecutionCounter()).isEqualTo(5);
        Assertions.assertThat((ZonedDateTime)scheduledJob.getLastUpdate()).isEqualTo((Object)LAST_UPDATE);
        Assertions.assertThat((Integer)scheduledJob.getPriority()).isEqualTo(2);
        Assertions.assertThat((Comparable)scheduledJob.getStatus()).isEqualTo((Object)STATUS);
        Assertions.assertThat((ZonedDateTime)scheduledJob.getExpirationTime()).isEqualTo((Object)TIME);
        Assertions.assertThat((String)scheduledJob.getRootProcessInstanceId()).isEqualTo("ID");
        Assertions.assertThat((String)scheduledJob.getRootProcessId()).isEqualTo(ROOT_PROCESS_ID);
        Assertions.assertThat((String)scheduledJob.getProcessId()).isEqualTo("ID");
        Assertions.assertThat((String)scheduledJob.getProcessInstanceId()).isEqualTo("ID");
        Assertions.assertThat((String)scheduledJob.getNodeInstanceId()).isEqualTo(NODE_INSTANCE_ID);
        Assertions.assertThat((String)scheduledJob.getCallbackEndpoint()).isEqualTo(ENDPOINT);
    }

    private void assertJobDetails(JobDetails jobDetails) {
        Assertions.assertThat((String)jobDetails.getId()).isEqualTo(ID);
        Assertions.assertThat((String)jobDetails.getScheduledId()).isEqualTo(SCHEDULED_ID);
        Assertions.assertThat((Integer)jobDetails.getExecutionCounter()).isEqualTo(5);
        Assertions.assertThat((Integer)jobDetails.getRetries()).isEqualTo(10);
        Assertions.assertThat((String)jobDetails.getCorrelationId()).isEqualTo(ID);
        Assertions.assertThat((ZonedDateTime)jobDetails.getLastUpdate()).isEqualTo((Object)LAST_UPDATE);
        Assertions.assertThat((Integer)jobDetails.getPriority()).isEqualTo(2);
        Assertions.assertThat((Comparable)jobDetails.getStatus()).isEqualTo((Object)STATUS);
        Assertions.assertThat((Comparable)jobDetails.getType()).isEqualTo((Object)JobDetails.Type.HTTP);
        Assertions.assertThat((Object)jobDetails.getRecipient()).isInstanceOf(Recipient.HTTPRecipient.class);
        Assertions.assertThat((String)((Recipient.HTTPRecipient)jobDetails.getRecipient()).getEndpoint()).isEqualTo(ENDPOINT);
        Assertions.assertThat((Object)jobDetails.getPayload()).isEqualTo((Object)payload);
    }
}

