/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xml;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.ForallDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.mvel.DrlDumper;
import org.drools.util.StringUtils;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.compiler.xml.compiler.XmlPackageReader;
import org.junit.jupiter.api.Test;

public class XmlPackageReaderTest {
    @Test
    public void testParseFrom() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseFrom.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        PatternDescr patterndescr = (PatternDescr)obj.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)patterndescr.getSource();
        MVELExprDescr accessordescriptor = (MVELExprDescr)from.getDataSource();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"cheesery.getCheeses(i+4)", (Object)accessordescriptor.getExpression());
        org.junit.jupiter.api.Assertions.assertEquals((Object)patterndescr.getObjectType(), (Object)"Cheese");
        org.junit.jupiter.api.Assertions.assertEquals((Object)patterndescr.getIdentifier(), (Object)"cheese");
    }

    @Test
    public void testAccumulate() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        org.junit.jupiter.api.Assertions.assertEquals((Object)patterncheese.getIdentifier(), (Object)"cheese");
        org.junit.jupiter.api.Assertions.assertEquals((Object)patterncheese.getObjectType(), (Object)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"total += $cheese.getPrice();", (Object)accumulatedescr.getActionCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"int total = 0;", (Object)accumulatedescr.getInitCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new Integer( total ) );", (Object)accumulatedescr.getResultCode());
        patternobj = obj.getLhs().getDescrs().get(1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patternmax = (PatternDescr)patternobj;
        org.junit.jupiter.api.Assertions.assertEquals((Object)patternmax.getIdentifier(), (Object)"max");
        org.junit.jupiter.api.Assertions.assertEquals((Object)patternmax.getObjectType(), (Object)"Number");
        accumulatedescr = (AccumulateDescr)patternmax.getSource();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)accumulatedescr.isExternalFunction());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"max", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)accumulatedescr.getFunctions().get(0)).getFunction());
        org.junit.jupiter.api.Assertions.assertNull((Object)accumulatedescr.getInitCode());
        org.junit.jupiter.api.Assertions.assertNull((Object)accumulatedescr.getActionCode());
        org.junit.jupiter.api.Assertions.assertNull((Object)accumulatedescr.getResultCode());
        org.junit.jupiter.api.Assertions.assertNull((Object)accumulatedescr.getReverseCode());
    }

    @Test
    public void testAccumulateMultiPattern() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(1);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        org.junit.jupiter.api.Assertions.assertEquals((Object)patterncheese.getIdentifier(), (Object)"cheese");
        org.junit.jupiter.api.Assertions.assertEquals((Object)patterncheese.getObjectType(), (Object)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"total += $cheese.getPrice();", (Object)accumulatedescr.getActionCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"int total = 0;", (Object)accumulatedescr.getInitCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new Integer( total ) );", (Object)accumulatedescr.getResultCode());
        AndDescr anddescr = (AndDescr)accumulatedescr.getInput();
        List descrlist = anddescr.getDescrs();
        PatternDescr[] listpattern = descrlist.toArray(new PatternDescr[descrlist.size()]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)listpattern[0].getObjectType(), (Object)"Milk");
        org.junit.jupiter.api.Assertions.assertEquals((Object)listpattern[1].getObjectType(), (Object)"Cup");
    }

    @Test
    public void testParseForall() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseForall.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        ForallDescr forall = (ForallDescr)obj.getLhs().getDescrs().get(0);
        List forallPaterns = forall.getDescrs();
        PatternDescr pattarnState = (PatternDescr)forallPaterns.get(0);
        PatternDescr personState = (PatternDescr)forallPaterns.get(1);
        PatternDescr cheeseState = (PatternDescr)forallPaterns.get(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)pattarnState.getObjectType(), (Object)"State");
        org.junit.jupiter.api.Assertions.assertEquals((Object)personState.getObjectType(), (Object)"Person");
        org.junit.jupiter.api.Assertions.assertEquals((Object)cheeseState.getObjectType(), (Object)"Cheese");
    }

    @Test
    public void testParseExists() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseExists.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object existdescr = obj.getLhs().getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(existdescr instanceof ExistsDescr));
        Object patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)((PatternDescr)patternDescriptor).getObjectType(), (Object)"Person");
        Object notDescr = obj.getLhs().getDescrs().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)notDescr.getClass().getName(), (Object)NotDescr.class.getName());
        existdescr = ((NotDescr)notDescr).getDescrs().get(0);
        patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)((PatternDescr)patternDescriptor).getObjectType(), (Object)"Cheese");
    }

    @Test
    public void testParseCollect() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseCollect.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseCollect.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParsePackageName() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParsePackageName.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
    }

    @Test
    public void testParseImport() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseImport.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)imports.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List functionImport = packageDescr.getFunctionImports();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.drools.function", (Object)((FunctionImportDescr)functionImport.get(0)).getTarget());
    }

    @Test
    public void testParseGlobal() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseGlobal.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)imports.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.X", (Object)x.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x", (Object)x.getIdentifier());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"yada", (Object)yada.getIdentifier());
    }

    @Test
    public void testParseFunction() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseFunction.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)imports.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.X", (Object)x.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x", (Object)x.getIdentifier());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"yada", (Object)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo", names.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bar", types.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bing", types.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"System.out.println(\"hello world\");", (Object)functionDescr.getText().trim());
    }

    @Test
    public void testParseRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRule.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRule.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        System.out.println(expectedWithoutHeader);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParseSimpleRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_SimpleRule1.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)imports.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.util.List", (Object)((ImportDescr)imports.get(0)).getTarget());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.drools.mvel.compiler.Person", (Object)((ImportDescr)imports.get(1)).getTarget());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"simple_rule1", (Object)ruleDescr.getName());
        AndDescr lhs = ruleDescr.getLhs();
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        ExprConstraintDescr expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name == \"darth\"", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"simple_rule2", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"age == 35 || == -3.5", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"simple_rule3", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"age == 35 || (!= 7.0 && != -70)", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"simple_rule3", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"name == $s", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"simple_rule4", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(name == $s) || (age == 35 || (!= 7.0 && != -70))", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(5);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"simple_rule5", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"(name == $s) || ((age != 34) && (age != 37) && (name != \"yoda\"))", (Object)expr.getExpression());
    }

    @Test
    public void testParseLhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseLhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseLhs.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParseRhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)imports.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.X", (Object)x.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x", (Object)x.getIdentifier());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"yada", (Object)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo", names.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bar", types.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bing", types.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"System.out.println(\"hello world\");", (Object)functionDescr.getText().trim());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"my rule", (Object)ruleDescr.getName());
        String consequence = (String)ruleDescr.getConsequence();
        Assertions.assertThat((String)consequence).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"System.out.println( \"hello\" );", (Object)consequence.trim());
    }

    @Test
    public void testParseQuery() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseQuery.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assertions.assertThat((Object)packageDescr).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)imports.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.X", (Object)x.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x", (Object)x.getIdentifier());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"yada", (Object)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo", names.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bar", types.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bing", types.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"System.out.println(\"hello world\");", (Object)functionDescr.getText().trim());
        QueryDescr queryDescr = (QueryDescr)packageDescr.getRules().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"my query", (Object)queryDescr.getName());
        AndDescr lhs = queryDescr.getLhs();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)lhs.getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Foo", (Object)patternDescr.getObjectType());
    }

    private XmlPackageReader getXmReader() {
        SemanticKnowledgeBuilderConfigurationImpl conf = new SemanticKnowledgeBuilderConfigurationImpl();
        XmlPackageReader xmlReader = new XmlPackageReader(conf.getSemanticModules());
        xmlReader.getParser().setClassLoader(XmlPackageReaderTest.class.getClassLoader());
        return xmlReader;
    }

    private String removeLicenseHeader(String content) {
        String[] lines = content.trim().split("\n");
        StringBuilder result = new StringBuilder();
        if (lines.length > 1 && lines[0].startsWith("/*")) {
            boolean inHeader = true;
            for (String line : lines) {
                if (line.trim().startsWith("package")) {
                    inHeader = false;
                }
                if (inHeader) continue;
                result.append(line);
                result.append("\n");
            }
            return result.toString();
        }
        return content;
    }
}

