/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.mvel.DrlDumper;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.compiler.xml.compiler.XmlDumper;
import org.jbpm.compiler.xml.compiler.XmlPackageReader;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DumperTestHelper {
    public static void XmlFile(String filename) throws Exception {
        SemanticKnowledgeBuilderConfigurationImpl conf = new SemanticKnowledgeBuilderConfigurationImpl();
        XmlPackageReader xmlPackageReader = new XmlPackageReader(conf.getSemanticModules());
        xmlPackageReader.getParser().setClassLoader(DumperTestHelper.class.getClassLoader());
        xmlPackageReader.read((Reader)new InputStreamReader(DumperTestHelper.class.getResourceAsStream(filename)));
        PackageDescr pkgOriginal = xmlPackageReader.getPackageDescr();
        XmlDumper dumper = new XmlDumper();
        String result = dumper.dump(pkgOriginal);
        String buffer = DumperTestHelper.readFile(filename);
        System.out.println(buffer);
        System.out.println(result);
        Assertions.assertThat((String)buffer).isEqualToIgnoringWhitespace((CharSequence)result);
        Assertions.assertThat((String)result).isNotNull();
    }

    public static void DrlFile(String filename) throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr pkgOriginal = parser.parse((Reader)new InputStreamReader(DumperTestHelper.class.getResourceAsStream(filename)));
        DrlDumper dumper = new DrlDumper();
        String result1 = dumper.dump(pkgOriginal);
        PackageDescr pkgDerivated = parser.parse((Reader)new StringReader(result1));
        String result2 = dumper.dump(pkgDerivated);
        System.out.println(result1);
        Assertions.assertThat((String)result1).isEqualToIgnoringWhitespace((CharSequence)result2);
    }

    public static String dump(String filename) throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkgOriginal = parser.parse((Reader)new InputStreamReader(DumperTestHelper.class.getResourceAsStream(filename)));
        DrlDumper dumper = new DrlDumper();
        return dumper.dump(pkgOriginal);
    }

    private static String readFile(String file) throws IOException {
        InputStreamReader reader = new InputStreamReader(DumperTestHelper.class.getResourceAsStream(file));
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }
}

