/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.drl.ast.descr.ReturnValueDescr;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.builder.MVELDialect;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.process.builder.dialect.mvel.MVELReturnValueEvaluatorBuilder;
import org.jbpm.process.instance.impl.MVELReturnValueEvaluator;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.SplitInstance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class MVELReturnValueConstraintEvaluatorBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleReturnValueConstraintEvaluator() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("pkg1");
        ReturnValueDescr descr = new ReturnValueDescr();
        descr.setText("return value");
        this.builder = new KnowledgeBuilderImpl(pkg, (KnowledgeBuilderConfigurationImpl)new SemanticKnowledgeBuilderConfigurationImpl());
        DialectCompiletimeRegistry dialectRegistry = this.builder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        PackageBuildContext context = new PackageBuildContext();
        context.init((DroolsAssemblerContext)this.builder, pkg, null, dialectRegistry, (Dialect)mvelDialect, null);
        this.builder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal Boolean value;"));
        ReturnValueConstraintEvaluator node = new ReturnValueConstraintEvaluator();
        MVELReturnValueEvaluatorBuilder evaluatorBuilder = new MVELReturnValueEvaluatorBuilder();
        evaluatorBuilder.build(context, node, descr, null);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        kruntime.getKieSession().setGlobal("value", (Object)true);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)kruntime.getKieSession());
        SplitInstance splitInstance = new SplitInstance();
        splitInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)this.builder.getPackage("pkg1").getDialectRuntimeRegistry().getDialectData("mvel");
        ((MVELReturnValueEvaluator)node.getReturnValueEvaluator()).compile(data);
        Assertions.assertTrue((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
        kruntime.getKieSession().setGlobal("value", (Object)false);
        Assertions.assertFalse((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
    }
}

