/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.drl.ast.descr.ActionDescr;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.builder.MVELDialect;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.process.builder.dialect.mvel.MVELActionBuilder;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.instance.KogitoProcessContextImpl;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.MVELAction;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieRuntime;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class MVELDecisionBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleAction() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("pkg1");
        ActionDescr actionDescr = new ActionDescr();
        actionDescr.setText("list.add( 'hello world' )");
        this.builder = new KnowledgeBuilderImpl(pkg, (KnowledgeBuilderConfigurationImpl)new SemanticKnowledgeBuilderConfigurationImpl());
        PackageRegistry pkgReg = this.builder.getPackageRegistry(pkg.getName());
        MVELDialect mvelDialect = (MVELDialect)pkgReg.getDialectCompiletimeRegistry().getDialect("mvel");
        PackageBuildContext context = new PackageBuildContext();
        context.init((DroolsAssemblerContext)this.builder, pkg, null, pkgReg.getDialectCompiletimeRegistry(), (Dialect)mvelDialect, null);
        this.builder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal java.util.List list;\n"));
        ActionNode actionNode = new ActionNode();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        actionNode.setAction((DroolsAction)action);
        MVELActionBuilder actionBuilder = new MVELActionBuilder();
        actionBuilder.build(context, (DroolsAction)action, actionDescr, (ContextResolver)actionNode);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)this.builder.getPackage("pkg1").getDialectRuntimeRegistry().getDialectData("mvel");
        KogitoProcessContextImpl processContext = new KogitoProcessContextImpl((KieRuntime)kruntime.getKieSession());
        ((MVELAction)actionNode.getAction().getMetaData("Action")).compile(data);
        ((Action)actionNode.getAction().getMetaData("Action")).execute((KogitoProcessContext)processContext);
        Assertions.assertEquals((Object)"hello world", list.get(0));
    }
}

