/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.Collection;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class KnowledgeBuilderTest
extends AbstractBaseTest {
    @Test
    public void testKnowledgeProviderWithProcesses() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new SemanticKnowledgeBuilderConfigurationImpl());
        Object str = "";
        str = (String)str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        str = (String)str + "<process xmlns=\"http://drools.org/drools-5.0/process\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\" ";
        str = (String)str + "         type=\"RuleFlow\" name=\"flow1\" id=\"0\" package-name=\"org.test1\" >";
        str = (String)str + "  <header/>\n";
        str = (String)str + "  <nodes><start id=\"1\" name=\"Start\" /><end id=\"2\" name=\"End\" /></nodes>\n";
        str = (String)str + "  <connections><connection from=\"1\" to=\"2\"/></connections>";
        str = (String)str + "</process>";
        builder.add(ResourceFactory.newByteArrayResource((byte[])((String)str).getBytes()), ResourceType.DRF);
        str = "";
        str = (String)str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        str = (String)str + "<process xmlns=\"http://drools.org/drools-5.0/process\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\" ";
        str = (String)str + "         type=\"RuleFlow\" name=\"flow2\" id=\"0\" package-name=\"org.test2\" >";
        str = (String)str + "  <header/>\n";
        str = (String)str + "  <nodes><start id=\"1\" name=\"Start\" /><end id=\"2\" name=\"End\" /></nodes>\n";
        str = (String)str + "  <connections><connection from=\"1\" to=\"2\"/></connections>";
        str = (String)str + "</process>";
        builder.add(ResourceFactory.newByteArrayResource((byte[])((String)str).getBytes()), ResourceType.DRF);
        Collection pkgs = builder.getKnowledgePackages();
        Assertions.assertNotNull((Object)pkgs);
        Assertions.assertEquals((int)2, (int)pkgs.size());
        KiePackage test1 = this.getKnowledgePackage(pkgs, "org.test1");
        Collection processes = test1.getProcesses();
        Assertions.assertEquals((int)1, (int)processes.size());
        Process process = this.getProcess(processes, "flow1");
        Assertions.assertEquals((Object)"flow1", (Object)process.getName());
        KiePackage test2 = this.getKnowledgePackage(pkgs, "org.test2");
        processes = test2.getProcesses();
        Assertions.assertEquals((int)1, (int)processes.size());
        process = this.getProcess(processes, "flow2");
        Assertions.assertEquals((Object)"flow2", (Object)process.getName());
    }

    public Process getProcess(Collection<Process> processes, String name) {
        for (Process process : processes) {
            if (!process.getName().equals(name)) continue;
            return process;
        }
        return null;
    }

    public KiePackage getKnowledgePackage(Collection<KiePackage> pkgs, String name) {
        for (KiePackage pkg : pkgs) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }
}

