/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ProcessDescr;
import org.drools.drl.ast.descr.ReturnValueDescr;
import org.drools.mvel.java.JavaDialect;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.builder.dialect.java.JavaReturnValueEvaluatorBuilder;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.SplitInstance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class JavaReturnValueConstraintEvaluatorBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleReturnValueConstraintEvaluator() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("pkg1");
        ProcessDescr processDescr = new ProcessDescr();
        processDescr.setClassName("Process1");
        processDescr.setName("Process1");
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        process.setName("Process1");
        process.setPackageName("pkg1");
        ReturnValueDescr descr = new ReturnValueDescr();
        descr.setText("return value;");
        this.builder = new KnowledgeBuilderImpl(pkg, (KnowledgeBuilderConfigurationImpl)new SemanticKnowledgeBuilderConfigurationImpl());
        DialectCompiletimeRegistry dialectRegistry = this.builder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        JavaDialect javaDialect = (JavaDialect)dialectRegistry.getDialect("java");
        ProcessBuildContext context = new ProcessBuildContext((DroolsAssemblerContext)this.builder, pkg, (Process)process, (BaseDescr)processDescr, dialectRegistry, (Dialect)javaDialect);
        this.builder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal Boolean value;"));
        ReturnValueConstraintEvaluator node = new ReturnValueConstraintEvaluator();
        JavaReturnValueEvaluatorBuilder evaluatorBuilder = new JavaReturnValueEvaluatorBuilder();
        evaluatorBuilder.build((PackageBuildContext)context, node, descr, null);
        ProcessDialectRegistry.getDialect((String)"java").addProcess(context);
        javaDialect.compileAll();
        Assertions.assertEquals((int)0, (int)javaDialect.getResults().size());
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        kruntime.getKieSession().setGlobal("value", (Object)true);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)kruntime.getKieSession());
        SplitInstance splitInstance = new SplitInstance();
        splitInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        Assertions.assertTrue((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
        kruntime.getKieSession().setGlobal("value", (Object)false);
        Assertions.assertFalse((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
    }
}

