/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.drl.ast.descr.ActionDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ProcessDescr;
import org.drools.mvel.java.JavaDialect;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.instance.KogitoProcessContextImpl;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class JavaActionBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleAction() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("pkg1");
        ActionDescr actionDescr = new ActionDescr();
        actionDescr.setText("list.add( \"hello world\" );");
        this.builder = new KnowledgeBuilderImpl(pkg, (KnowledgeBuilderConfigurationImpl)new SemanticKnowledgeBuilderConfigurationImpl());
        DialectCompiletimeRegistry dialectRegistry = this.builder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        JavaDialect javaDialect = (JavaDialect)dialectRegistry.getDialect("java");
        ProcessDescr processDescr = new ProcessDescr();
        processDescr.setClassName("Process1");
        processDescr.setName("Process1");
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        process.setName("Process1");
        process.setPackageName("pkg1");
        ProcessBuildContext context = new ProcessBuildContext((DroolsAssemblerContext)this.builder, this.builder.getPackage("pkg1"), null, (BaseDescr)processDescr, dialectRegistry, (Dialect)javaDialect);
        context.init((DroolsAssemblerContext)this.builder, pkg, null, dialectRegistry, (Dialect)javaDialect, null);
        this.builder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal java.util.List list;\n"));
        ActionNode actionNode = new ActionNode();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        actionNode.setAction((DroolsAction)action);
        ProcessDialect dialect = ProcessDialectRegistry.getDialect((String)"java");
        dialect.getActionBuilder().build((PackageBuildContext)context, (DroolsAction)action, actionDescr, (ContextResolver)actionNode);
        dialect.addProcess(context);
        javaDialect.compileAll();
        Assertions.assertEquals((int)0, (int)javaDialect.getResults().size());
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessContextImpl processContext = new KogitoProcessContextImpl(kruntime.getKieRuntime());
        ((Action)actionNode.getAction().getMetaData("Action")).execute((KogitoProcessContext)processContext);
        Assertions.assertEquals((Object)"hello world", list.get(0));
    }
}

