/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;

public class ProcessWorkItemTest
extends AbstractBaseTest {
    @Test
    public void testWorkItem() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <variables>\n      <variable name=\"UserName\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>John Doe</value>\n      </variable>\n      <variable name=\"Person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\" />\n      </variable>\n      <variable name=\"MyObject\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n      <variable name=\"Number\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{UserName}</value>\n        </parameter>\n        <parameter name=\"Content\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{Person.name}</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Attachment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />      <mapping type=\"in\" from=\"#{Person.name}\" to=\"Comment\" />      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />      <mapping type=\"out\" from=\"#{Result.length()}\" to=\"Number\" />    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)kruntime.startProcess("org.drools.actions", parameters);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        Assertions.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Content"));
        Assertions.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Comment"));
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), Collections.singletonMap("Result", ""), new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        parameters = new HashMap();
        parameters.put("UserName", "Jane Doe");
        parameters.put("MyObject", "SomeString");
        person = new Person();
        person.setName("Jane Doe");
        parameters.put("Person", person);
        processInstance = (WorkflowProcessInstance)kruntime.startProcess("org.drools.actions", parameters);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("ActorId"));
        Assertions.assertEquals((Object)"SomeString", (Object)workItem.getParameter("Attachment"));
        Assertions.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Content"));
        Assertions.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Comment"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("Result", "SomeOtherString");
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), results, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((Object)"SomeOtherString", (Object)processInstance.getVariable("MyObject"));
        Assertions.assertEquals((Object)15, (Object)processInstance.getVariable("Number"));
    }

    @Test
    public void testWorkItemImmediateCompletion() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <variables>\n      <variable name=\"UserName\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>John Doe</value>\n      </variable>\n      <variable name=\"Person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\" />\n      </variable>\n      <variable name=\"MyObject\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n      <variable name=\"Number\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{UserName}</value>\n        </parameter>\n        <parameter name=\"Content\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{Person.name}</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Attachment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ImmediateTestWorkItemHandler handler = new ImmediateTestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)kruntime.startProcess("org.drools.actions", parameters);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    private static class ImmediateTestWorkItemHandler
    implements KogitoWorkItemHandler {
        private ImmediateTestWorkItemHandler() {
        }

        public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
            manager.completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        }

        public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        }
    }
}

