/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.io.ByteArrayResource;
import org.drools.io.ReaderResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.jbpm.compiler.xml.compiler.SemanticKnowledgeBuilderConfigurationImpl;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.WorkflowProcessInstanceUpgrader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class ProcessUpgradeTest
extends AbstractBaseTest {
    @Test
    public void testDefaultUpgrade() throws Exception {
        Object rule = "package org.test;\n";
        rule = (String)rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "  ruleflow-group \"hello\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $p : Person( ) \n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( $p );\n";
        rule = (String)rule + "end";
        this.builder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new SemanticKnowledgeBuilderConfigurationImpl());
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader((String)rule)), ResourceType.DRL);
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(this.builder.getKnowledgePackages());
        KogitoProcessRuntime kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)kbase.newKieSession());
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        kruntime.getKieSession().insert((Object)p);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.test.ruleflow");
        Assertions.assertEquals((int)1, (int)kruntime.getKieSession().getProcessInstances().size());
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow2\" package-name=\"org.test\" >\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <actionNode id=\"4\" name=\"Action\" >      <action type=\"expression\" dialect=\"java\">System.out.println();\nlist.add(\"Executed\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"4\"/>\n    <connection from=\"4\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new SemanticKnowledgeBuilderConfigurationImpl());
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process2)), ResourceType.DRF);
        kbase.addPackages(this.builder.getKnowledgePackages());
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KogitoProcessRuntime)kruntime, (String)processInstance.getStringId(), (String)"org.test.ruleflow2", new HashMap());
        Assertions.assertEquals((Object)"org.test.ruleflow2", (Object)processInstance.getProcessId());
        kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testMappingUpgrade() throws Exception {
        Object rule = "package org.test;\n";
        rule = (String)rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "  ruleflow-group \"hello\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $p : Person( ) \n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( $p );\n";
        rule = (String)rule + "end";
        this.builder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new SemanticKnowledgeBuilderConfigurationImpl());
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader((String)rule)), ResourceType.DRL);
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(this.builder.getKnowledgePackages());
        KogitoProcessRuntime kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)kbase.newKieSession());
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        kruntime.getKieSession().insert((Object)p);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.test.ruleflow");
        Assertions.assertEquals((int)1, (int)kruntime.getKogitoProcessInstances().size());
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow2\" package-name=\"org.test\" >\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"102\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <actionNode id=\"4\" name=\"Action\" >      <action type=\"expression\" dialect=\"java\">System.out.println();\nlist.add(\"Executed\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"102\"/>\n    <connection from=\"102\" to=\"4\"/>\n    <connection from=\"4\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new SemanticKnowledgeBuilderConfigurationImpl());
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process2)), ResourceType.DRF);
        kbase.addPackages(this.builder.getKnowledgePackages());
        HashMap<String, Long> mapping = new HashMap<String, Long>();
        mapping.put("2", 102L);
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KogitoProcessRuntime)kruntime, (String)processInstance.getStringId(), (String)"org.test.ruleflow2", mapping);
        Assertions.assertEquals((Object)"org.test.ruleflow2", (Object)processInstance.getProcessId());
        kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testCompositeMappingUpgrade() throws Exception {
        Object rule = "package org.test;\n";
        rule = (String)rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "  ruleflow-group \"hello\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $p : Person( ) \n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( $p );\n";
        rule = (String)rule + "end";
        this.builder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)new SemanticKnowledgeBuilderConfigurationImpl());
        this.builder.add((Resource)new ByteArrayResource(((String)rule).getBytes()), ResourceType.DRL);
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <composite id=\"2\" name=\"Composite\" >\n      <nodes>\n        <workItem id=\"1\" name=\"Hello\" >\n          <work name=\"Human Task\" >\n          </work>\n        </workItem>\n      </nodes>\n      <connections>\n      </connections>\n      <in-ports>\n        <in-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeInType=\"DROOLS_DEFAULT\" />\n      </in-ports>\n      <out-ports>\n        <out-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeOutType=\"DROOLS_DEFAULT\" />\n      </out-ports>\n    </composite>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(this.builder.getKnowledgePackages());
        KogitoProcessRuntime kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)kbase.newKieSession());
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        kruntime.getKieSession().insert((Object)p);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.test.ruleflow");
        Assertions.assertEquals((int)1, (int)kruntime.getKieSession().getProcessInstances().size());
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow2\" package-name=\"org.test\" >\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <composite id=\"2\" name=\"Composite\" >\n      <nodes>\n        <workItem id=\"101\" name=\"Hello\" >\n          <work name=\"Human Task\" >\n          </work>\n        </workItem>\n        <actionNode id=\"2\" name=\"Action\" >          <action type=\"expression\" dialect=\"java\">System.out.println();\nlist.add(\"Executed\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"101\" to=\"2\"/>\n      </connections>\n      <in-ports>\n        <in-port type=\"DROOLS_DEFAULT\" nodeId=\"101\" nodeInType=\"DROOLS_DEFAULT\" />\n      </in-ports>\n      <out-ports>\n        <out-port type=\"DROOLS_DEFAULT\" nodeId=\"2\" nodeOutType=\"DROOLS_DEFAULT\" />\n      </out-ports>\n    </composite>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process2)), ResourceType.DRF);
        kbase.addPackages(this.builder.getKnowledgePackages());
        HashMap<String, Long> mapping = new HashMap<String, Long>();
        mapping.put("2:1", 101L);
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KogitoProcessRuntime)kruntime, (String)processInstance.getStringId(), (String)"org.test.ruleflow2", mapping);
        Assertions.assertEquals((Object)"org.test.ruleflow2", (Object)processInstance.getProcessId());
        kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }
}

