/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.drools.io.ReaderResource;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTimerTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessTimerTest.class);

    @Test
    void testIncorrectTimerNode() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <end id=\"2\" name=\"End\" />\n    <timerNode id=\"3\" name=\"Timer\" delay=\"800msdss\" period=\"200mssds\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"3\" />\n    <connection from=\"3\" to=\"2\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        Assertions.assertEquals((int)2, (int)this.builder.getErrors().size());
        for (KnowledgeBuilderError error : this.builder.getErrors()) {
            logger.error(error.toString());
        }
    }

    @Test
    void testOnEntryTimerWorkItemExecuted() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Work\" >\n      <timers>\n        <timer id=\"1\" delay=\"300\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList myList = new ArrayList();
        kruntime.getKieSession().setGlobal("myList", myList);
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.timer");
        Assertions.assertEquals((int)0, (int)myList.size());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        try {
            TimeUnit.MILLISECONDS.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)myList.size());
        kruntime.getKieSession().dispose();
    }
}

