/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class ProcessStateTest
extends AbstractBaseTest {
    @Test
    public void testManualSignalState() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" name=\"StateA\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"toB\" />\n       <constraint toNodeId=\"4\" name=\"toC\" />\n      </constraints>\n    </state>\n    <state id=\"3\" name=\"StateB\" />\n    <state id=\"4\" name=\"StateC\" />\n    <end id=\"5\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"2\" to=\"4\" />\n    <connection from=\"3\" to=\"2\" />\n    <connection from=\"4\" to=\"5\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Collection nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)1, (int)nodeInstances.size());
        StateNodeInstance stateInstance = (StateNodeInstance)nodeInstances.iterator().next();
        Assertions.assertEquals((Object)"StateA", (Object)stateInstance.getNodeName());
        processInstance.signalEvent("signal", (Object)"toB");
        nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)1, (int)nodeInstances.size());
        stateInstance = (StateNodeInstance)nodeInstances.iterator().next();
        Assertions.assertEquals((Object)"StateB", (Object)stateInstance.getNodeName());
        processInstance.signalEvent("signal", (Object)"StateA");
        nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)1, (int)nodeInstances.size());
        stateInstance = (StateNodeInstance)nodeInstances.iterator().next();
        Assertions.assertEquals((Object)"StateA", (Object)stateInstance.getNodeName());
        processInstance.signalEvent("signal", (Object)"toC");
        nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)1, (int)nodeInstances.size());
        stateInstance = (StateNodeInstance)nodeInstances.iterator().next();
        Assertions.assertEquals((Object)"StateC", (Object)stateInstance.getNodeName());
        processInstance.signalEvent("signal", (Object)"Invalid");
        nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)1, (int)nodeInstances.size());
        stateInstance = (StateNodeInstance)nodeInstances.iterator().next();
        Assertions.assertEquals((Object)"StateC", (Object)stateInstance.getNodeName());
        processInstance.signalEvent("signal", (Object)"End");
        nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)0, (int)nodeInstances.size());
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testImmediateStateConstraint1() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"one\" >\n            eval(true)        </constraint>       <constraint toNodeId=\"4\" name=\"two\" >\n           eval(false)        </constraint>      </constraints>\n    </state>\n    <actionNode id=\"3\" name=\"ActionNode1\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"1\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n    <actionNode id=\"5\" name=\"ActionNode2\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"2\");</action>\n    </actionNode>\n    <end id=\"6\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"2\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"1", list.get(0));
    }

    @Test
    public void testImmediateStateConstraintPriorities1() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"one\" priority=\"1\" >\n            eval(true)        </constraint>       <constraint toNodeId=\"5\" name=\"two\" priority=\"2\" >\n           eval(true)        </constraint>      </constraints>\n    </state>\n    <actionNode id=\"3\" name=\"ActionNode1\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"1\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n    <actionNode id=\"5\" name=\"ActionNode2\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"2\");</action>\n    </actionNode>\n    <end id=\"6\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"2\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"1", list.get(0));
    }

    @Test
    public void testImmediateStateConstraintPriorities2() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"one\" priority=\"2\" >\n            eval(true)        </constraint>       <constraint toNodeId=\"5\" name=\"two\" priority=\"1\" >\n           eval(true)        </constraint>      </constraints>\n    </state>\n    <actionNode id=\"3\" name=\"ActionNode1\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"1\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n    <actionNode id=\"5\" name=\"ActionNode2\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"2\");</action>\n    </actionNode>\n    <end id=\"6\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"2\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"2", list.get(0));
    }

    @Test
    public void testDelayedStateConstraint() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"one\" >\n            Person( age &gt; 21 )        </constraint>       <constraint toNodeId=\"4\" name=\"two\" >\n           Person( age &lt;= 21 )        </constraint>      </constraints>\n    </state>\n    <actionNode id=\"3\" name=\"ActionNode1\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"1\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n    <actionNode id=\"5\" name=\"ActionNode2\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"2\");</action>\n    </actionNode>\n    <end id=\"6\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"2\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Assertions.assertTrue((boolean)list.isEmpty());
        Person person = new Person("John Doe", 30);
        kruntime.getKieSession().insert((Object)person);
        kruntime.getKieSession().fireAllRules();
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"1", list.get(0));
    }

    @Test
    public void testDelayedStateConstraint2() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"age &gt; 21\" >\n            Person( age &gt; 21 )        </constraint>       <constraint toNodeId=\"5\" name=\"age &lt;=21 \" >\n           Person( age &lt;= 21 )        </constraint>      </constraints>\n    </state>\n    <actionNode id=\"3\" name=\"ActionNode1\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"1\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n    <actionNode id=\"5\" name=\"ActionNode2\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"2\");</action>\n    </actionNode>\n    <end id=\"6\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"2\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Assertions.assertTrue((boolean)list.isEmpty());
        Person person = new Person("John Doe", 20);
        kruntime.getKieSession().insert((Object)person);
        kruntime.getKieSession().fireAllRules();
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"2", list.get(0));
    }

    @Test
    @Disabled(value="Needs fix")
    public void FIXMEtestDelayedStateConstraintPriorities1() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"one\" priority=\"1\" >\n            Person( )        </constraint>       <constraint toNodeId=\"5\" name=\"two\" priority=\"2\" >\n           Person( )        </constraint>      </constraints>\n    </state>\n    <actionNode id=\"3\" name=\"ActionNode1\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"1\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n    <actionNode id=\"5\" name=\"ActionNode2\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"2\");</action>\n    </actionNode>\n    <end id=\"6\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"2\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Assertions.assertTrue((boolean)list.isEmpty());
        Person person = new Person("John Doe", 30);
        kruntime.getKieSession().insert((Object)person);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"1", list.get(0));
    }

    @Test
    @Disabled(value="Needs fix")
    public void FIXMEtestDelayedStateConstraintPriorities2() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" >\n      <constraints>\n        <constraint toNodeId=\"3\" name=\"one\" priority=\"2\" >\n            Person( )        </constraint>       <constraint toNodeId=\"5\" name=\"two\" priority=\"1\" >\n           Person( )        </constraint>      </constraints>\n    </state>\n    <actionNode id=\"3\" name=\"ActionNode1\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"1\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n    <actionNode id=\"5\" name=\"ActionNode2\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"2\");</action>\n    </actionNode>\n    <end id=\"6\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"2\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Assertions.assertTrue((boolean)list.isEmpty());
        Person person = new Person("John Doe", 30);
        kruntime.getKieSession().insert((Object)person);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"2", list.get(0));
    }

    @Test
    public void testActionState() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"s\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>a</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" name=\"State\" >\n      <onEntry>        <action type=\"expression\" dialect=\"mvel\" >list.add(\"Action1\" + s);</action>\n        <action type=\"expression\" dialect=\"java\" >list.add(\"Action2\" + s);</action>\n      </onEntry>\n      <onExit>\n        <action type=\"expression\" dialect=\"mvel\" >list.add(\"Action3\" + s);</action>\n        <action type=\"expression\" dialect=\"java\" >list.add(\"Action4\" + s);</action>\n      </onExit>\n    </state>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Collection nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)1, (int)nodeInstances.size());
        StateNodeInstance stateInstance = (StateNodeInstance)nodeInstances.iterator().next();
        Assertions.assertEquals((Object)"State", (Object)stateInstance.getNodeName());
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertTrue((boolean)list.contains("Action1a"));
        Assertions.assertTrue((boolean)list.contains("Action2a"));
        processInstance.signalEvent("signal", (Object)"End");
        nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)0, (int)nodeInstances.size());
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertTrue((boolean)list.contains("Action3a"));
        Assertions.assertTrue((boolean)list.contains("Action4a"));
    }

    @Test
    public void testTimerState() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.state\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"s\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>a</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <state id=\"2\" name=\"State\" >\n      <timers>\n        <timer id=\"1\" delay=\"1s\" period=\"2s\" >\n          <action type=\"expression\" dialect=\"mvel\" >list.add(\"Timer1\" + s);</action>\n        </timer>\n        <timer id=\"2\" delay=\"1s\" period=\"2s\" >\n          <action type=\"expression\" dialect=\"mvel\" >list.add(\"Timer2\" + s);</action>\n        </timer>\n      </timers>\n    </state>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        new Thread(() -> kruntime.getKieSession().fireUntilHalt()).start();
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)kruntime.startProcess("org.drools.state");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Collection nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)1, (int)nodeInstances.size());
        StateNodeInstance stateInstance = (StateNodeInstance)nodeInstances.iterator().next();
        Assertions.assertEquals((Object)"State", (Object)stateInstance.getNodeName());
        Assertions.assertEquals((int)0, (int)list.size());
        try {
            TimeUnit.SECONDS.sleep(4L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertTrue((boolean)list.contains("Timer1a"));
        Assertions.assertTrue((boolean)list.contains("Timer2a"));
        processInstance.signalEvent("signal", (Object)"End");
        nodeInstances = processInstance.getNodeInstances();
        Assertions.assertEquals((int)0, (int)nodeInstances.size());
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)4, (int)list.size());
        try {
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)4, (int)list.size());
        kruntime.getKieSession().halt();
    }
}

