/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.io.ReaderResource;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSplitTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessSplitTest.class);

    @Test
    public void testSplitWithProcessInstanceConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" priority=\"2\" type=\"rule\" dialect=\"mvel\" >eval(true)</constraint>        <constraint toNodeId=\"6\" name=\"constraint\" priority=\"1\" type=\"rule\" dialect=\"mvel\" >processInstance: org.jbpm.ruleflow.instance.RuleFlowProcessInstance()Person( name == (ProcessUtils.getValue(processInstance, \"name\")) )</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        Person john = new Person("John Doe", 20);
        Person jane = new Person("Jane Doe", 20);
        Person julie = new Person("Julie Doe", 20);
        kruntime.getKieSession().insert((Object)john);
        kruntime.getKieSession().insert((Object)jane);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", john.getName());
        KogitoProcessInstance processInstance1 = kruntime.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", jane.getName());
        KogitoProcessInstance processInstance2 = kruntime.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", julie.getName());
        KogitoProcessInstance processInstance3 = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance1.getState());
        Assertions.assertEquals((int)2, (int)processInstance2.getState());
        Assertions.assertEquals((int)2, (int)processInstance3.getState());
        Assertions.assertEquals((int)2, (int)list.size());
    }

    @Test
    public void testSplitWithProcessInstanceConstraint2() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.kie.api.runtime.process.WorkflowProcessInstance\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"rule\" dialect=\"mvel\" >eval(true)</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" name=\"constraint\" priority=\"1\" type=\"rule\" dialect=\"mvel\" >processInstance: WorkflowProcessInstance()Person( name == ( processInstance.getVariable(\"name\") ) )</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        for (KnowledgeBuilderError error : this.builder.getErrors()) {
            logger.error(error.toString());
        }
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        Person john = new Person("John Doe", 20);
        Person jane = new Person("Jane Doe", 20);
        Person julie = new Person("Julie Doe", 20);
        kruntime.getKieSession().insert((Object)john);
        kruntime.getKieSession().insert((Object)jane);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", john.getName());
        KogitoProcessInstance processInstance1 = kruntime.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", jane.getName());
        KogitoProcessInstance processInstance2 = kruntime.startProcess("org.jbpm.process-split", params);
        params = new HashMap();
        params.put("name", julie.getName());
        KogitoProcessInstance processInstance3 = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance1.getState());
        Assertions.assertEquals((int)2, (int)processInstance2.getState());
        Assertions.assertEquals((int)2, (int)processInstance3.getState());
        Assertions.assertEquals((int)2, (int)list.size());
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testSplitWithMVELContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return kcontext.getVariable(\"person\") != null &amp;&amp; ((Person) kcontext.getVariable(\"person\")).name != null;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person("John Doe"));
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testSplitWithJavaContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return kcontext.getVariable(\"name\") != null &amp;&amp; ((String) kcontext.getVariable(\"name\")).length() > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testSplitWithMVELkContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return kcontext.getVariable(\"person\") != null &amp;&amp; ((org.jbpm.integrationtests.test.Person) kcontext.getVariable(\"person\")).name != null;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person("John Doe"));
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testSplitWithJavakContextConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return kcontext.getVariable(\"name\") != null &amp;&amp; ((String) kcontext.getVariable(\"name\")).length() > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testSplitWithMVELVariableConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return name != null &amp;&amp; name.length > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testSplitWithJavaVariableConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return name != null &amp;&amp; name.length() > 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testSplitWithMVELGlobalConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"mvel\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"mvel\" >return list != null &amp;&amp; list.size() >= 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"mvel\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John Doe");
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testSplitWithJavaGlobalConstraint() {
        StringReader source = new StringReader("<process xmlns=\"http://drools.org/drools-5.0/process\"         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.jbpm.process-split\" package-name=\"org.jbpm\" >  <header>    <imports>      <import name=\"org.jbpm.integrationtests.test.Person\" />      <import name=\"org.jbpm.integrationtests.ProcessSplitTest.ProcessUtils\" />    </imports>    <globals>      <global identifier=\"list\" type=\"java.util.List\" />    </globals>  </header>  <nodes>    <actionNode id=\"2\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >insert(kcontext.getProcessInstance());</action>    </actionNode>    <split id=\"4\" name=\"Split\" type=\"2\" >      <constraints>        <constraint toNodeId=\"8\" toType=\"DROOLS_DEFAULT\" priority=\"2\" type=\"code\" dialect=\"java\" >return true;</constraint>        <constraint toNodeId=\"6\" toType=\"DROOLS_DEFAULT\" priority=\"1\" type=\"code\" dialect=\"java\" >return list != null &amp;&amp; list.size() >= 0;</constraint>      </constraints>    </split>    <end id=\"8\" name=\"End\" />    <actionNode id=\"6\" name=\"Action\" >        <action type=\"expression\" dialect=\"java\" >list.add(kcontext.getProcessInstance().getStringId());</action>    </actionNode>    <start id=\"1\" name=\"Start\" />    <end id=\"3\" name=\"End\" />  </nodes>  <connections>    <connection from=\"1\" to=\"2\" />    <connection from=\"2\" to=\"4\" />    <connection from=\"4\" to=\"8\" />    <connection from=\"4\" to=\"6\" />    <connection from=\"6\" to=\"3\" />  </connections></process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.jbpm.process-split");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
    }

    public static class ProcessUtils {
        public static Object getValue(RuleFlowProcessInstance processInstance, String name) {
            VariableScopeInstance scope = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            return scope.getVariable(name);
        }
    }
}

