/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import org.drools.io.ReaderResource;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class ProcessRuleFlowGroupTest
extends AbstractBaseTest {
    @Test
    public void testRuleSetProcessContext() throws Exception {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.ruleset\" package-name=\"org.jbpm\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"RuleSet\" ruleFlowGroup=\"MyGroup\" >\n    </ruleSet>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        StringReader source2 = new StringReader("package org.jbpm;\n\nimport org.jbpm.integrationtests.test.Person;\nimport org.kie.api.runtime.process.ProcessContext;\n\nrule MyRule ruleflow-group \"MyGroup\" dialect \"mvel\" \n  when\n    Person( age > 25 )\n  then\n    System.out.println(drools.getContext(ProcessContext).getProcessInstance().getProcessName());\nend");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        this.builder.add((Resource)new ReaderResource((Reader)source2), ResourceType.DRL);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        kruntime.getKieRuntime().getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)"true");
        Person person = new Person();
        person.setAge(30);
        kruntime.getKieSession().insert((Object)person);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.ruleset");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        kruntime.getKieSession().fireAllRules();
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }
}

