/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.drools.drl.parser.DroolsError;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMultiThreadTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMultiThreadTest.class);

    @Test
    public void testMultiThreadProcessInstanceSignalling() {
        int THREAD_COUNT = 2;
        try {
            int i;
            boolean success = true;
            Thread[] t = new Thread[2];
            this.builder.addProcessFromXml((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ProcessMultithreadEvent.rf")));
            if (this.builder.getErrors().getErrors().length > 0) {
                for (DroolsError error : this.builder.getErrors().getErrors()) {
                    logger.error(error.toString());
                }
                Assertions.fail((String)"Could not parse process");
            }
            KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
            ArrayList list = new ArrayList();
            kruntime.getKieSession().setGlobal("list", list);
            KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.integrationtests.multithread");
            ProcessInstanceSignalRunner[] r = new ProcessInstanceSignalRunner[2];
            for (i = 0; i < t.length; ++i) {
                r[i] = new ProcessInstanceSignalRunner(i, processInstance, "event" + (i + 1));
                t[i] = new Thread((Runnable)r[i], "thread-" + i);
                t[i].start();
            }
            for (i = 0; i < t.length; ++i) {
                t[i].join();
                if (r[i].getStatus() != ProcessInstanceSignalRunner.Status.FAIL) continue;
                success = false;
            }
            if (!success) {
                Assertions.fail((String)"Multithread test failed. Look at the stack traces for details. ");
            }
            Assertions.assertEquals((int)2, (int)list.size());
            Assertions.assertNotEquals(list.get(1), list.get(0));
            Assertions.assertEquals((int)2, (int)processInstance.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    public static class ProcessInstanceSignalRunner
    implements Runnable {
        private KogitoProcessInstance processInstance;
        private String type;
        private Status status;
        private int id;

        public ProcessInstanceSignalRunner(int id, KogitoProcessInstance processInstance, String type) {
            this.id = id;
            this.processInstance = processInstance;
            this.type = type;
            this.status = Status.SUCCESS;
        }

        @Override
        public void run() {
            try {
                this.processInstance.signalEvent(this.type, null);
            }
            catch (Exception e) {
                this.status = Status.FAIL;
                logger.warn("{} failed: {}", (Object)Thread.currentThread().getName(), (Object)e.getMessage());
            }
        }

        public int getId() {
            return this.id;
        }

        public Status getStatus() {
            return this.status;
        }

        public static enum Status {
            SUCCESS,
            FAIL;

        }
    }
}

