/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.io.ReaderResource;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMarshallingTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMarshallingTest.class);

    @Test
    public void testMarshallingProcessInstancesAndGlobals() throws Exception {
        Object rule = "package org.test;\n";
        rule = (String)rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "  ruleflow-group \"hello\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $p : Person( ) \n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( $p );\n";
        rule = (String)rule + "end";
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"Hello\" ruleFlowGroup=\"hello\" />\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add(ResourceFactory.newReaderResource((Reader)new StringReader((String)rule)), ResourceType.DRL);
        this.builder.add(ResourceFactory.newReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        kruntime.getKieRuntime().getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)true);
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        kruntime.getKieSession().insert((Object)p);
        kruntime.startProcess("org.test.ruleflow");
        Assertions.assertEquals((int)1, (int)kruntime.getKieSession().getProcessInstances().size());
        kruntime.getKieSession().fireAllRules();
        Assertions.assertEquals((int)1, (int)((List)kruntime.getKieSession().getGlobal("list")).size());
        Assertions.assertEquals((Object)p, ((List)kruntime.getKieSession().getGlobal("list")).get(0));
        Assertions.assertEquals((int)0, (int)kruntime.getKieSession().getProcessInstances().size());
    }

    @Test
    public void testMarshallingProcessInstanceWithWorkItem() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n    <variables>\n      <variable name=\"myVariable\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>OldValue</value>\n      </variable>\n    </variables>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Email\" >\n      <work name=\"Email\" >\n        <parameter name=\"Subject\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Mail</value>\n        </parameter>\n        <parameter name=\"Text\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>This is an email</value>\n        </parameter>\n        <parameter name=\"To\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>you@mail.com</value>\n        </parameter>\n        <parameter name=\"From\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>me@mail.com</value>\n        </parameter>\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)handler);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myVariable", "ThisIsMyValue");
        kruntime.startProcess("org.test.ruleflow", variables);
        Assertions.assertEquals((int)1, (int)kruntime.getKogitoProcessInstances().size());
        Assertions.assertNotNull((Object)handler.getWorkItem());
        Assertions.assertEquals((int)1, (int)kruntime.getKogitoProcessInstances().size());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstance)kruntime.getKogitoProcessInstances().iterator().next()).getContextInstance("VariableScope");
        Assertions.assertEquals((Object)"ThisIsMyValue", (Object)variableScopeInstance.getVariable("myVariable"));
        kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)0, (int)kruntime.getKogitoProcessInstances().size());
    }

    @Test
    public void testMarshallingWithMultipleHumanTasks() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n    <header>\n      <variables>\n        <variable name=\"list\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"java.util.List\" />\n        </variable>\n      </variables>\n    </header>\n\n    <nodes>\n      <forEach id=\"4\" name=\"ForEach\" variableName=\"item\" collectionExpression=\"list\" >\n        <nodes>\n          <humanTask id=\"1\" name=\"Human Task\" >\n            <work name=\"Human Task\" >\n              <parameter name=\"Comment\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"ActorId\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"Priority\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"TaskName\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n                <value>Do something: #{item}</value>\n              </parameter>\n            </work>\n          </humanTask>\n          <humanTask id=\"2\" name=\"Human Task Again\" >\n            <work name=\"Human Task\" >\n              <parameter name=\"Comment\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"ActorId\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"Priority\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"TaskName\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n                <value>Do something else: #{item}</value>\n              </parameter>\n            </work>\n          </humanTask>\n        </nodes>\n        <connections>\n          <connection from=\"1\" to=\"2\" />\n        </connections>\n        <in-ports>\n          <in-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeInType=\"DROOLS_DEFAULT\" />\n        </in-ports>\n        <out-ports>\n          <out-port type=\"DROOLS_DEFAULT\" nodeId=\"2\" nodeOutType=\"DROOLS_DEFAULT\" />\n        </out-ports>\n      </forEach>\n      <start id=\"1\" name=\"Start\" />\n      <end id=\"3\" name=\"End\" />\n    </nodes>\n\n    <connections>\n      <connection from=\"1\" to=\"4\" />\n      <connection from=\"4\" to=\"3\" />\n    </connections>\n\n</process>\n";
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestListWorkItemHandler handler = new TestListWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        HashMap<String, ArrayList<String>> parameters = new HashMap<String, ArrayList<String>>();
        parameters.put("list", list);
        KogitoProcessInstance kogitoProcessInstance = kruntime.startProcess("com.sample.ruleflow", parameters);
        Assertions.assertEquals((int)1, (int)kruntime.getKogitoProcessInstances().size());
        for (int i = 0; i < list.size() * 2; ++i) {
            this.completeWorkItems(kruntime, handler);
        }
        Assertions.assertEquals((int)0, (int)kruntime.getKogitoProcessInstances().size());
        Assertions.assertEquals((int)2, (int)kogitoProcessInstance.getState());
    }

    public void completeWorkItems(KogitoProcessRuntime kruntime, TestListWorkItemHandler handler) {
        KogitoWorkItem workItem = handler.getWorkItems().get(0);
        handler.reset();
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
    }

    @Test
    public void testVariablePersistenceMarshallingStrategies() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n    <variables>\n      <variable name=\"myVariable\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>OldValue</value>\n      </variable>\n      <variable name=\"myPerson\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\"/>\n      </variable>\n    </variables>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Email\" >\n      <work name=\"Report\" >\n        <parameter name=\"Subject\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Mail</value>\n        </parameter>\n        <parameter name=\"Subject\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Mail</value>\n        </parameter>\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Report", (KogitoWorkItemHandler)handler);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("myVariable", "ThisIsMyValue");
        Person myPerson = new Person("Nikola Tesla", 156);
        variables.put("myPerson", myPerson);
        kruntime.startProcess("org.test.ruleflow", variables);
        Assertions.assertEquals((int)1, (int)kruntime.getKogitoProcessInstances().size());
        Assertions.assertNotNull((Object)handler.getWorkItem());
        Assertions.assertEquals((int)1, (int)kruntime.getKogitoProcessInstances().size());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstance)kruntime.getKogitoProcessInstances().iterator().next()).getContextInstance("VariableScope");
        Assertions.assertEquals((Object)"ThisIsMyValue", (Object)variableScopeInstance.getVariable("myVariable"));
        Assertions.assertEquals((Object)myPerson, (Object)variableScopeInstance.getVariable("myPerson"));
        kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)0, (int)kruntime.getKogitoProcessInstances().size());
    }

    private static class TestListWorkItemHandler
    implements KogitoWorkItemHandler {
        private List<KogitoWorkItem> workItems = new ArrayList<KogitoWorkItem>();

        private TestListWorkItemHandler() {
        }

        public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
            logger.debug("Executing workItem {}", workItem.getParameter("TaskName"));
            this.workItems.add(workItem);
        }

        public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
            this.workItems.remove(workItem);
        }

        public List<KogitoWorkItem> getWorkItems() {
            return this.workItems;
        }

        public void reset() {
            this.workItems.clear();
        }
    }
}

