/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.drools.io.ReaderResource;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class ProcessHumanTaskTest
extends AbstractBaseTest {
    @Test
    public void testHumanTask() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.humantask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testSwimlane() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <swimlanes>\n      <swimlane name=\"actor1\" />\n    </swimlanes>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" swimlane=\"actor1\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <mapping type=\"out\" from=\"ActorId\" to=\"ActorId\" />    </humanTask>\n    <humanTask id=\"3\" name=\"HumanTask\" swimlane=\"actor1\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something else</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <mapping type=\"out\" from=\"ActorId\" to=\"ActorId\" />    </humanTask>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.humantask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"Do something", (Object)workItem.getParameter("TaskName"));
        Assertions.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        HashMap results = new HashMap();
        ((HumanTaskWorkItemImpl)workItem).setActualOwner("Jane Doe");
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), results, new Policy[0]);
        workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"Do something else", (Object)workItem.getParameter("TaskName"));
        Assertions.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("SwimlaneActorId"));
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testHumanTaskCancel() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        ProcessInstance processInstance = (ProcessInstance)kruntime.startProcess("org.drools.humantask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        processInstance.setState(3);
        Assertions.assertTrue((boolean)handler.isAborted());
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testHumanTaskCancel2() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <onExit>\n        <action type=\"expression\" name=\"Cancel\" dialect=\"java\" >((org.jbpm.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();</action>\n      </onExit>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.humantask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        Assertions.assertFalse((boolean)handler.isAborted());
    }
}

