/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.event.DefaultAgendaEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFlowControlTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessFlowControlTest.class);

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testRuleFlowConstraintDialects() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ConstraintDialects.rfm")));
        logger.error(this.builder.getErrors().toString());
        Assertions.assertEquals((int)0, (int)this.builder.getErrors().getErrors().length);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList<Integer> inList = new ArrayList<Integer>();
        ArrayList outList = new ArrayList();
        kruntime.getKieSession().setGlobal("inList", inList);
        kruntime.getKieSession().setGlobal("outList", outList);
        inList.add(1);
        inList.add(3);
        inList.add(6);
        inList.add(25);
        FactHandle handle = kruntime.getKieSession().insert(inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertEquals((int)4, (int)outList.size());
        Assertions.assertEquals((Object)"MVELCodeConstraint was here", outList.get(0));
        Assertions.assertEquals((Object)"JavaCodeConstraint was here", outList.get(1));
        Assertions.assertEquals((Object)"MVELRuleConstraint was here", outList.get(2));
        Assertions.assertEquals((Object)"JavaRuleConstraint was here", outList.get(3));
        outList.clear();
        inList.remove((Object)1);
        kruntime.getKieSession().update(handle, inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertEquals((int)3, (int)outList.size());
        Assertions.assertEquals((Object)"JavaCodeConstraint was here", outList.get(0));
        Assertions.assertEquals((Object)"MVELRuleConstraint was here", outList.get(1));
        Assertions.assertEquals((Object)"JavaRuleConstraint was here", outList.get(2));
        outList.clear();
        inList.remove((Object)6);
        kruntime.getKieSession().update(handle, inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertEquals((int)2, (int)outList.size());
        Assertions.assertEquals((Object)"JavaCodeConstraint was here", outList.get(0));
        Assertions.assertEquals((Object)"JavaRuleConstraint was here", outList.get(1));
        outList.clear();
        inList.remove((Object)3);
        kruntime.getKieSession().update(handle, inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertEquals((int)1, (int)outList.size());
        Assertions.assertEquals((Object)"JavaRuleConstraint was here", outList.get(0));
        outList.clear();
        inList.remove((Object)25);
        kruntime.getKieSession().update(handle, inList);
        KogitoProcessInstance processInstance = kruntime.startProcess("ConstraintDialects");
        Assertions.assertEquals((int)5, (int)processInstance.getState());
    }

    @Test
    public void testRuleFlow() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        kruntime.getKieSession().fireAllRules();
        Assertions.assertEquals((int)0, (int)list.size());
        KogitoProcessInstance processInstance = kruntime.startProcess("0");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((Object)"Rule1", list.get(0));
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assertions.assertEquals((Object)"Rule4", list.get(3));
    }

    @Test
    public void testRuleFlowClear() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ruleflowClear.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ruleflowClear.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        final ArrayList activations = new ArrayList();
        DefaultAgendaEventListener listener = new DefaultAgendaEventListener(){

            public void matchCancelled(MatchCancelledEvent event) {
                activations.add(event.getMatch());
            }
        };
        kruntime.getKieSession().addEventListener((AgendaEventListener)listener);
        InternalAgenda agenda = (InternalAgenda)kruntime.getKieSession().getAgenda();
        kruntime.getKieSession().fireAllRules();
        agenda.evaluateEagerList();
        Assertions.assertEquals((int)4, (int)agenda.sizeOfRuleFlowGroup("flowgroup-1"));
        Assertions.assertEquals((int)0, (int)((InternalAgendaGroup)agenda.getAgendaGroup("MAIN")).size());
        Assertions.assertEquals((int)0, (int)activations.size());
        ((InternalAgenda)kruntime.getKieSession().getAgenda()).clearAndCancelRuleFlowGroup("flowgroup-1");
        Assertions.assertEquals((int)0, (int)((InternalAgendaGroup)agenda.getAgendaGroup("MAIN")).size());
        Assertions.assertEquals((int)0, (int)agenda.sizeOfRuleFlowGroup("flowgroup-1"));
        Assertions.assertEquals((int)4, (int)activations.size());
    }

    @Test
    public void testRuleFlowInPackage() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        kruntime.getKieSession().fireAllRules();
        Assertions.assertEquals((int)0, (int)list.size());
        KogitoProcessInstance processInstance = kruntime.startProcess("0");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((Object)"Rule1", list.get(0));
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assertions.assertEquals((Object)"Rule4", list.get(3));
    }

    @Test
    public void testLoadingRuleFlowInPackage1() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.drl")));
        Assertions.assertTrue((this.builder.getPackages().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadingRuleFlowInPackage2() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("ruleflow.rfm")));
        Assertions.assertTrue((this.builder.getPackages().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadingRuleFlowInPackage3() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("empty_ruleflow.rfm")));
        Assertions.assertTrue((this.builder.getPackages().length > 0 ? 1 : 0) != 0);
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testRuleFlowActionDialects() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ActionDialects.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        kruntime.startProcess("ActionDialects");
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"mvel was here", list.get(0));
        Assertions.assertEquals((Object)"java was here", list.get(1));
    }

    @Test
    public void testLoadingRuleFlowNoPackageName() {
        this.builder.addRuleFlow((Reader)new InputStreamReader(this.getClass().getResourceAsStream("error_ruleflow.rfm")));
        Assertions.assertEquals((int)3, (int)this.builder.getErrors().getErrors().length);
    }
}

