/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.io.ReaderResource;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieRuntime;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.logger.KogitoRuntimeLoggerFactory;
import org.kie.kogito.process.workitem.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDynamicNodeTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDynamicNodeTest.class);

    @Test
    @Disabled(value="Not done yet")
    public void TODOtestDynamicActions() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <actionNode id=\"1\" name=\"Action1\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action1\");\nlist.add(\"Action1\");</action>\n        </actionNode>\n        <actionNode id=\"2\" name=\"Action2\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action2\");\nlist.add(\"Action2\");</action>\n        </actionNode>\n        <actionNode id=\"3\" name=\"Action3\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action3\");\nlist.add(\"Action3\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"3\" />\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <actionNode id=\"3\" name=\"Action4\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action4\");\nlist.add(\"Action4\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        for (KnowledgeBuilderError error : this.builder.getErrors()) {
            logger.error(error.toString());
        }
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.dynamic");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)4, (int)list.size());
    }

    @Test
    @Disabled(value="Not done yet")
    public void TODOtestDynamicAsyncActions() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <workItem id=\"1\" name=\"Work\" >\n          <work name=\"Work\" />\n        </workItem>\n        <actionNode id=\"2\" name=\"Action2\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action2\");\nlist.add(\"Action2\");</action>\n        </actionNode>\n        <actionNode id=\"3\" name=\"Action3\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action3\");\nlist.add(\"Action3\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"3\" />\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <actionNode id=\"3\" name=\"Action4\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action4\");\nlist.add(\"Action4\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        for (KnowledgeBuilderError error : this.builder.getErrors()) {
            logger.error(error.toString());
        }
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Work", (KogitoWorkItemHandler)testHandler);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.dynamic");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Assertions.assertEquals((int)1, (int)list.size());
        KogitoWorkItem workItem = testHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testAddDynamicWorkItem() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <completionCondition>autocomplete</completionCondition>\n      <nodes>\n        <actionNode id=\"1\" name=\"Action\" >\n          <action type=\"expression\" dialect=\"java\" >System.out.println(\"Action\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        KieRuntimeLogger logger = KogitoRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)kruntime.getKieSession(), (String)"test");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.dynamic");
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((KogitoWorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("TaskName", "Dynamic Task");
        Assertions.assertNull((Object)handler.getWorkItem());
        Assertions.assertEquals((int)0, (int)dynamicContext.getNodeInstances().size());
        DynamicUtils.addDynamicWorkItem((DynamicNodeInstance)dynamicContext, (KieRuntime)kruntime.getKieRuntime(), (String)"Human Task", parameters);
        Assertions.assertNotNull((Object)handler.getWorkItem());
        Assertions.assertEquals((int)1, (int)dynamicContext.getNodeInstances().size());
        logger.close();
    }

    @Test
    public void testAddDynamicSubProcess() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <completionCondition>autocomplete</completionCondition>\n      <nodes>\n        <actionNode id=\"1\" name=\"Action\" >\n          <action type=\"expression\" dialect=\"java\" >System.out.println(\"Action\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n</process>");
        StringReader source2 = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"subflow\" id=\"org.drools.subflow\" package-name=\"org.drools\" >\n\n  <header>\n    <variables>\n      <variable name=\"x\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(x);</action>\n    </actionNode>\n    <workItem id=\"3\" name=\"Work\" >\n      <work name=\"Human Task\" />\n    </workItem>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        this.builder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        this.builder.add(ResourceFactory.newReaderResource((Reader)source2), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        KieRuntimeLogger logger = KogitoRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)kruntime.getKieSession(), (String)"test");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = kruntime.startProcess("org.drools.dynamic");
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((KogitoWorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("x", "NewValue");
        Assertions.assertNull((Object)handler.getWorkItem());
        Assertions.assertEquals((int)0, (int)dynamicContext.getNodeInstances().size());
        DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)kruntime.getKieRuntime(), (String)"org.drools.subflow", parameters);
        Assertions.assertNotNull((Object)handler.getWorkItem());
        Assertions.assertEquals((int)1, (int)dynamicContext.getNodeInstances().size());
        logger.close();
    }
}

