/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.io.ReaderResource;
import org.jbpm.integrationtests.TestVariable;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.integrationtests.test.Message;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class ProcessActionTest
extends AbstractBaseTest {
    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testOnEntryExit() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <onEntry>\n        <action type=\"expression\" name=\"Print\" dialect=\"mvel\" >list.add(\"Executing on entry action\");</action>\n      </onEntry>\n      <onExit>\n        <action type=\"expression\" name=\"Print\" dialect=\"java\" >list.add(\"Executing on exit action1\");</action>\n        <action type=\"expression\" name=\"Print\" dialect=\"java\" >list.add(\"Executing on exit action2\");</action>\n      </onExit>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions");
        Assertions.assertEquals((int)1, (int)KogitoProcessInstance2.getState());
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((int)1, (int)list.size());
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((int)2, (int)KogitoProcessInstance2.getState());
    }

    @Test
    public void testActionContextJava() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"variable\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nString myVariable = (String) kcontext.getVariable(\"variable\");\nlist.add(myVariable);\nString nodeName = kcontext.getNodeInstance().getNodeName();\nlist.add(nodeName);\ninsert( new Message() );\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions");
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"SomeText", list.get(0));
        Assertions.assertEquals((Object)"MyActionNode", list.get(1));
        Collection factHandles = kruntime.getKieSession().getFactHandles(object -> object instanceof Message);
        Assertions.assertFalse((boolean)factHandles.isEmpty());
        Assertions.assertEquals((int)2, (int)KogitoProcessInstance2.getState());
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testActionContextMVEL() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"variable\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\nSystem.out.println(kcontext.getKieRuntime());\nString myVariable = (String) kcontext.getVariable(\"variable\");\nlist.add(myVariable);\nString nodeName = kcontext.getNodeInstance().getNodeName();\nlist.add(nodeName);\ninsert( new Message() );\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        if (this.builder.hasErrors()) {
            Assertions.fail((String)this.builder.getErrors().toString());
        }
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions");
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"SomeText", list.get(0));
        Assertions.assertEquals((Object)"MyActionNode", list.get(1));
        Collection factHandles = kruntime.getKieSession().getFactHandles(object -> object instanceof Message);
        Assertions.assertFalse((boolean)factHandles.isEmpty());
        Assertions.assertEquals((int)2, (int)KogitoProcessInstance2.getState());
    }

    @Test
    public void testActionVariableJava() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.TestVariable\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.TestVariable\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nlist.add(person.getName());\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        TestVariable person = new TestVariable("John Doe");
        HashMap<String, TestVariable> params = new HashMap<String, TestVariable>();
        params.put("person", person);
        KogitoProcessInstance KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions", params);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"John Doe", list.get(0));
        Assertions.assertEquals((int)2, (int)KogitoProcessInstance2.getState());
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testActionVariableMVEL() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.TestVariable\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"person\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.TestVariable\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\nlist.add(person.name);\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        TestVariable person = new TestVariable("John Doe");
        HashMap<String, TestVariable> params = new HashMap<String, TestVariable>();
        params.put("person", person);
        KogitoProcessInstance KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions", params);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"John Doe", list.get(0));
        Assertions.assertEquals((int)2, (int)KogitoProcessInstance2.getState());
    }

    @Test
    public void testActionNameConflict() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions1\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"Action1\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions2\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >list.add(\"Action2\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions1");
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"Action1", list.get(0));
        list.clear();
        KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions2");
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"Action2", list.get(0));
        Assertions.assertEquals((int)2, (int)KogitoProcessInstance2.getState());
    }

    @Test
    public void testActionContextJavaBackwardCheck() {
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"variable\" >\n        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nString myVariable = (String) kcontext.getVariable(\"variable\");\nlist.add(myVariable);\nString nodeName = kcontext.getNodeInstance().getNodeName();\nlist.add(nodeName);\ninsert( new Message() );\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        this.builder.add((Resource)new ReaderResource((Reader)source), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance KogitoProcessInstance2 = kruntime.startProcess("org.drools.actions");
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"SomeText", list.get(0));
        Assertions.assertEquals((Object)"MyActionNode", list.get(1));
        Collection factHandles = kruntime.getKieSession().getFactHandles(object -> object instanceof Message);
        Assertions.assertFalse((boolean)factHandles.isEmpty());
        Assertions.assertEquals((int)2, (int)KogitoProcessInstance2.getState());
    }
}

