/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jbpm.compiler.xml.ProcessSemanticModule;
import org.jbpm.compiler.xml.SemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.compiler.xml.core.SemanticModules;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXml
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(TestXml.class);

    @Test
    public void testSimpleXml() throws Exception {
        SemanticModules modules = new SemanticModules();
        modules.addSemanticModule((SemanticModule)new ProcessSemanticModule());
        XmlProcessReader reader = new XmlProcessReader(modules, this.getClass().getClassLoader());
        reader.read((Reader)new InputStreamReader(TestXml.class.getResourceAsStream("XmlTest.xml")));
        List processes = reader.getProcess();
        Assertions.assertNotNull((Object)processes);
        Assertions.assertEquals((int)1, (int)processes.size());
        RuleFlowProcess process = (RuleFlowProcess)processes.get(0);
        Assertions.assertNotNull((Object)process);
        String output = XmlRuleFlowProcessDumper.INSTANCE.dump((WorkflowProcess)process);
        logger.info(output);
        reader = new XmlProcessReader(new SemanticModules(), this.getClass().getClassLoader());
        reader.read((Reader)new StringReader(output));
    }
}

