/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.canonical;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import org.jbpm.compiler.canonical.ReflectionUtils;
import org.jbpm.process.instance.KogitoProcessContextImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;

public class ReflectionUtilsTest {
    @Test
    public void testGetMethod() throws ReflectiveOperationException {
        ServiceExample instance = new ServiceExample();
        Method m = ReflectionUtils.getMethod((ClassLoader)Thread.currentThread().getContextClassLoader(), ServiceExample.class, (String)"primitiveType", Arrays.asList("String", "Integer"));
        Assertions.assertEquals((Object)2, (Object)m.invoke((Object)instance, "pepe", 2));
        m = ReflectionUtils.getMethod((ClassLoader)Thread.currentThread().getContextClassLoader(), ServiceExample.class, (String)"primitiveType", Arrays.asList("String", "Float"));
        Assertions.assertEquals((Object)Float.valueOf(2.0f), (Object)m.invoke((Object)instance, "pepe", Float.valueOf(2.0f)));
        KogitoProcessContextImpl context = new KogitoProcessContextImpl(null){

            public Object getVariable(String variableName) {
                return variableName;
            }
        };
        m = ReflectionUtils.getMethod((ClassLoader)Thread.currentThread().getContextClassLoader(), ServiceExample.class, (String)"getStringWithContext", Arrays.asList("String"));
        Assertions.assertEquals((Object)"dummy-boy", (Object)m.invoke((Object)instance, "dummy", context));
        m = ReflectionUtils.getMethod((ClassLoader)Thread.currentThread().getContextClassLoader(), ServiceExample.class, (String)"getStringWithContext", Collections.emptyList());
        Assertions.assertEquals((Object)"boy", (Object)m.invoke((Object)instance, context));
    }

    private static class ServiceExample {
        private ServiceExample() {
        }

        public int primitiveType(String s, int a) {
            return a;
        }

        public Float primitiveType(String s, Float a) {
            return a;
        }

        public String getStringWithContext(String prefix, KogitoProcessContext context) {
            return prefix + "-" + context.getVariable("boy");
        }

        public String getStringWithContext(KogitoProcessContext context) {
            return (String)context.getVariable("boy");
        }
    }
}

