/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.canonical;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jbpm.compiler.canonical.ModelMetaData;
import org.jbpm.compiler.canonical.ProcessMetaData;
import org.jbpm.compiler.canonical.ProcessToExecModelGenerator;
import org.jbpm.process.builder.dialect.feel.FeelCompilationException;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.definition.process.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessToExecModelGeneratorTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessToExecModelGeneratorTest.class);

    @Test
    public void testScriptAndWorkItemGeneration() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)factory.variable("order", (DataType)new ObjectDataType("com.myspace.demo.Order")).variable("approver", (DataType)new ObjectDataType("String")).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").workItemNode(1L).name("Log")).workName("Log")).done()).actionNode(2L).name("Dump order").action("java", "System.out.println(\"Order has been created \" + order);").done()).endNode(3L).name("end")).terminate(false).done()).startNode(4L).name("start")).done()).connection(2L, 1L)).connection(4L, 2L)).connection(1L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        ProcessMetaData processMetadata = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)processMetadata, (String)"Dumper should return non null class for process");
        logger.debug(processMetadata.getGeneratedClassModel().toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"orders", (Object)processMetadata.getExtractedProcessId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"demo.orders", (Object)processMetadata.getProcessId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"orders", (Object)processMetadata.getProcessName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.0", (Object)processMetadata.getProcessVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.myspace.demo.OrdersProcess", (Object)processMetadata.getProcessClassName());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)processMetadata.getGeneratedClassModel());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processMetadata.getWorkItems().size());
    }

    public static Stream<Arguments> invalidVariables() {
        return Stream.of(Arguments.of((Object[])new String[]{"com.myspace.demo.Order order2 = null; System.out.println(\"Order has been created \" + order);java.util.Arrays.toString(new int[]{1, 2});System.out.println(orders);", "uses unknown variable in the script: orders"}), Arguments.of((Object[])new String[]{"a = 2", "unable to parse Java content: Parse error. Found \"}\", expected one of  \"!=\" \"%\" \"%=\" \"&\" \"&&\" \"&=\" \"*\" \"*=\" \"+\" \"+=\" \"-\" \"-=\" \"->\" \"/\" \"/=\" \"::\" \";\" \"<\" \"<<=\" \"<=\" \"=\" \"==\" \">\" \">=\" \">>=\" \">>>=\" \"?\" \"^\" \"^=\" \"instanceof\" \"|\" \"|=\" \"||\""}), Arguments.of((Object[])new String[]{"a = 2;", "uses unknown variable in the script: a"}), Arguments.of((Object[])new String[]{"a.toString(); Integer i = Integer.valueOf(\"1\");", "uses unknown variable in the script: a"}), Arguments.of((Object[])new String[]{"System.out.println(\"Order has been created \" + x);", "uses unknown variable in the script: x"}), Arguments.of((Object[])new String[]{"System.out.println(\"[\" + (new java.util.Date()) + \"] [\" + java.lang.Thread.currentThread().getName() +\"]\");\njava.util.ArrayList list = new java.util.ArrayList();\nSystem.out.println(Integer.valueOf(x));", "uses unknown variable in the script: x"}));
    }

    @ParameterizedTest(name="{index} {0}")
    @MethodSource(value={"invalidVariables"})
    public void testScriptInvalidVariable(String script, String message) {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)factory.variable("order", (DataType)new ObjectDataType("com.myspace.demo.Order")).variable("approver", (DataType)new ObjectDataType("String")).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").startNode(1L).name("start")).done()).actionNode(2L).name("Dump order 1").action("java", script).done()).endNode(3L).name("end")).terminate(false).done()).connection(1L, 2L)).connection(2L, 3L);
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> factory.validate()).withMessage(String.format("Process could not be validated ![Process 'orders' [demo.orders]: Node 'Dump order 1' [2] %s]", message));
    }

    @Test
    public void testScriptAndWorkItemModelGeneration() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)factory.variable("order", (DataType)new ObjectDataType("com.myspace.demo.Order")).variable("approver", (DataType)new ObjectDataType("String")).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").workItemNode(1L).name("Log")).workName("Log")).done()).actionNode(2L).name("Dump order").action("java", "System.out.println(\"Order has been created \" + order);").done()).endNode(3L).name("end")).terminate(false).done()).startNode(4L).name("start")).done()).connection(2L, 1L)).connection(4L, 2L)).connection(1L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        ModelMetaData modelMetadata = ProcessToExecModelGenerator.INSTANCE.generateModel((WorkflowProcess)process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)modelMetadata, (String)"Dumper should return non null class for process");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"com.myspace.demo.OrdersModel", (Object)modelMetadata.getModelClassName());
    }

    @Test
    public void testGatewayFEEL() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)factory.variable("approver", (DataType)new StringDataType()).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").splitNode(1L).type(2).constraint(2L, "cA", "code", "FEEL", "if true then true else false").constraint(3L, "cB", "code", "java", "return false; ").done()).endNode(2L).name("end A")).terminate(false).done()).endNode(3L).name("end B")).terminate(false).done()).startNode(4L).name("start")).done()).connection(4L, 1L)).connection(1L, 2L, "cA")).connection(1L, 3L, "cB");
        RuleFlowProcess process = factory.validate().getProcess();
        ProcessMetaData processMetadata = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)processMetadata, (String)"Dumper should return non null class for process");
        logger.debug(processMetadata.getGeneratedClassModel().toString());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)processMetadata.getGeneratedClassModel());
    }

    @Test
    public void testGatewayFEELWrongIfMissingElse() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)factory.variable("approver", (DataType)new StringDataType()).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").splitNode(1L).type(2).constraint(2L, "cA", "code", "FEEL", "if true then true").constraint(3L, "cB", "code", "java", "return false; ").done()).endNode(2L).name("end A")).terminate(false).done()).endNode(3L).name("end B")).terminate(false).done()).startNode(4L).name("start")).done()).connection(4L, 1L)).connection(1L, 2L, "cA")).connection(1L, 3L, "cB");
        Assertions.assertThatExceptionOfType(FeelCompilationException.class).isThrownBy(() -> {
            RuleFlowProcess process = factory.validate().getProcess();
            ProcessMetaData processMetadata = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process);
        }).withStackTraceContaining("Detected 'if' expression without 'else' part");
    }

    @Test
    public void testGatewayFEELwrongUnkVariable() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)factory.variable("approver", (DataType)new StringDataType()).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").splitNode(1L).type(2).constraint(2L, "cA", "code", "FEEL", "approver=\"Matteo\"").constraint(3L, "cB", "code", "FEEL", "unexisting=1").done()).endNode(2L).name("end A")).terminate(false).done()).endNode(3L).name("end B")).terminate(false).done()).startNode(4L).name("start")).done()).connection(4L, 1L)).connection(1L, 2L, "cA")).connection(1L, 3L, "cB");
        Assertions.assertThatExceptionOfType(FeelCompilationException.class).isThrownBy(() -> {
            RuleFlowProcess process = factory.validate().getProcess();
            ProcessMetaData processMetadata = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process);
        }).withStackTraceContaining("Unknown variable 'unexisting'");
    }

    @Test
    public void testScriptVariablewithDefaultValue() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)factory.variable("order", (DataType)new ObjectDataType("com.myspace.demo.Order")).variable("approver", (DataType)new StringDataType(), (Object)"john", "customTags", null).variable("age", (DataType)new IntegerDataType(), (Object)"1", "customTags", null).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").workItemNode(1L).name("Log")).workName("Log")).done()).actionNode(2L).name("Dump order").action("java", "System.out.println(\"Order has been created \" + order);").done()).endNode(3L).name("end")).terminate(false).done()).startNode(4L).name("start")).done()).connection(2L, 1L)).connection(4L, 2L)).connection(1L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        ProcessMetaData processMetadata = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)processMetadata, (String)"Dumper should return non null class for process");
    }
}

