/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.drl.ast.descr.PackageDescr;
import org.jbpm.process.core.Context;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.KieDefinition;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;

public class PackageBuilderTest
extends AbstractBaseTest {
    @Test
    public void testRuleFlow() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/org/jbpm/integrationtests/ruleflow.rfm");
        Assertions.assertNotNull((Object)in);
        this.builder.addPackage(new PackageDescr("com.sample"));
        this.builder.addRuleFlow((Reader)new InputStreamReader(in));
        InternalKnowledgePackage pkg = this.builder.getPackage("com.sample");
        Assertions.assertNotNull((Object)pkg);
        Map flows = pkg.getRuleFlows();
        Assertions.assertNotNull((Object)flows);
        Assertions.assertEquals((int)1, (int)flows.size());
        Assertions.assertTrue((boolean)flows.containsKey("0"));
        Process p = (Process)flows.get("0");
        Assertions.assertTrue((boolean)(p instanceof WorkflowProcessImpl));
        InternalKnowledgePackage pkg2 = (InternalKnowledgePackage)DroolsStreamUtils.streamIn((byte[])DroolsStreamUtils.streamOut((Object)pkg));
        Assertions.assertNotNull((Object)pkg2);
        flows = pkg2.getRuleFlows();
        Assertions.assertNotNull((Object)flows);
        Assertions.assertEquals((int)1, (int)flows.size());
        Assertions.assertTrue((boolean)flows.containsKey("0"));
        p = (Process)flows.get("0");
        Assertions.assertTrue((boolean)(p instanceof WorkflowProcessImpl));
    }

    @Test
    public void testPackageRuleFlows() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("boo");
        MockRuleFlow rf = new MockRuleFlow("1");
        pkg.addProcess((Process)rf);
        Assertions.assertTrue((boolean)pkg.getRuleFlows().containsKey("1"));
        Assertions.assertSame((Object)rf, pkg.getRuleFlows().get("1"));
        MockRuleFlow rf2 = new MockRuleFlow("2");
        pkg.addProcess((Process)rf2);
        Assertions.assertTrue((boolean)pkg.getRuleFlows().containsKey("1"));
        Assertions.assertSame((Object)rf, pkg.getRuleFlows().get("1"));
        Assertions.assertTrue((boolean)pkg.getRuleFlows().containsKey("2"));
        Assertions.assertSame((Object)rf2, pkg.getRuleFlows().get("2"));
        pkg.removeRuleFlow("1");
        Assertions.assertTrue((boolean)pkg.getRuleFlows().containsKey("2"));
        Assertions.assertSame((Object)rf2, pkg.getRuleFlows().get("2"));
        Assertions.assertFalse((boolean)pkg.getRuleFlows().containsKey("1"));
    }

    class MockRuleFlow
    implements Process {
        private String id;

        MockRuleFlow(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return null;
        }

        public String getType() {
            return null;
        }

        public String getVersion() {
            return null;
        }

        public String getPackageName() {
            return null;
        }

        public void setId(String id) {
        }

        public void setName(String name) {
        }

        public void setType(String type) {
        }

        public void setVersion(String version) {
        }

        public void setPackageName(String packageName) {
        }

        public void addContext(Context context) {
        }

        public List<Context> getContexts(String contextId) {
            return null;
        }

        public Context getDefaultContext(String contextId) {
            return null;
        }

        public void setDefaultContext(Context context) {
        }

        public Context getContext(String contextType, long id) {
            return null;
        }

        public Map<String, Object> getMetaData() {
            return null;
        }

        public Object getMetaData(String name) {
            return null;
        }

        public void setMetaData(String name, Object value) {
        }

        public Resource getResource() {
            return null;
        }

        public void setResource(Resource resource) {
        }

        public String[] getGlobalNames() {
            return null;
        }

        public Map<String, String> getGlobals() {
            return null;
        }

        public List<String> getImports() {
            return null;
        }

        public void setGlobals(Map<String, String> globals) {
        }

        public void setImports(List<String> imports) {
        }

        public List<String> getFunctionImports() {
            return null;
        }

        public void setFunctionImports(List<String> functionImports) {
        }

        public KieDefinition.KnowledgeType getKnowledgeType() {
            return KieDefinition.KnowledgeType.PROCESS;
        }

        public String getNamespace() {
            return null;
        }
    }
}

