/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.resources;

import org.kie.kogito.test.resources.AbstractJobServiceResource;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class JobServiceKafkaResource
extends AbstractJobServiceResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobServiceKafkaResource.class);
    private final KogitoKafkaContainer kafka = new KogitoKafkaContainer();

    public void start() {
        LOGGER.info("Start JobServiceKafka test resource");
        this.properties.clear();
        LOGGER.info("Start Kafka");
        Network network = Network.newNetwork();
        this.kafka.withNetwork(network);
        this.kafka.withNetworkAliases(new String[]{"kafka"});
        this.kafka.waitingFor((WaitStrategy)Wait.forListeningPort());
        this.kafka.start();
        String kafkaURL = this.kafka.getBootstrapServers();
        LOGGER.info("kafkaURL: {}", (Object)this.kafka.getBootstrapServers());
        String kafkaInternalUrl = "kafka:29092";
        LOGGER.info("kafkaInternalURL: {}", (Object)kafkaInternalUrl);
        this.properties.put("kafka.bootstrap.servers", kafkaURL);
        this.properties.put("spring.kafka.bootstrap-servers", kafkaURL);
        this.properties.put("quarkus.profile", "events-support");
        this.jobService.withNetwork(network);
        this.jobService.setKafkaURL(kafkaInternalUrl);
        this.jobService.setQuarkusProfile("events-support");
        this.jobService.start();
        LOGGER.info("JobServiceKafka test resource started");
    }

    public void stop() {
        LOGGER.info("Stop JobServiceKafka test resource");
        this.jobService.stop();
        this.kafka.stop();
        LOGGER.info("JobServiceKafka test resource stopped");
    }
}

