/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana;

import java.util.TreeMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.grafana.model.functions.ExprBuilder;
import org.kie.kogito.grafana.model.functions.IncreaseFunction;
import org.kie.kogito.grafana.model.functions.SumFunction;

public class ExprBuilderTest {
    @Test
    public void givenATargetWhenNullGrafanaFunctionsAreAppliedThenTheOriginalTargetIsReturned() {
        String target = "api_test{hanlder=\"hello\"}";
        String result = ExprBuilder.apply((String)target, null);
        Assertions.assertEquals((Object)target, (Object)result);
    }

    @Test
    public void givenATargetWhenNoGrafanaFunctionsAreAppliedThenTheOriginalTargetIsReturned() {
        String target = "api_test{hanlder=\"hello\"}";
        String result = ExprBuilder.apply((String)target, new TreeMap());
        Assertions.assertEquals((Object)target, (Object)result);
    }

    @Test
    public void givenATargetWhenGrafanaFunctionsAreAppliedThenTheOriginalTargetIsReturned() {
        String target = "api_test{hanlder=\"hello\"}";
        TreeMap<Integer, Object> map = new TreeMap<Integer, Object>();
        map.put(1, new SumFunction());
        map.put(2, new IncreaseFunction("10m"));
        String expectedResult = "increase(sum(api_test{hanlder=\"hello\"})[10m])";
        String result = ExprBuilder.apply((String)target, map);
        Assertions.assertEquals((Object)expectedResult, (Object)result);
    }
}

