/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.explainability.integrationtests.opennlp;

import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.ExplainabilityMetrics;
import org.kie.kogito.explainability.utils.ValidationUtils;

class OpenNLPLimeExplainerTest {
    OpenNLPLimeExplainerTest() {
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void testOpenNLPLangDetect(int seed) throws Exception {
        Random random = new Random();
        random.setSeed(seed);
        LimeConfig limeConfig = new LimeConfig().withSamples(100).withPerturbationContext(new PerturbationContext(random, 2));
        LimeExplainer limeExplainer = new LimeExplainer(limeConfig);
        InputStream is = this.getClass().getResourceAsStream("/opennlp/langdetect-183.bin");
        LanguageDetectorModel languageDetectorModel = new LanguageDetectorModel(is);
        LanguageDetectorME languageDetector = new LanguageDetectorME(languageDetectorModel);
        PredictionProvider model = arg_0 -> OpenNLPLimeExplainerTest.lambda$testOpenNLPLangDetect$1((LanguageDetector)languageDetector, arg_0);
        String inputText = "italiani,spaghetti pizza mandolino";
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)inputText, s -> Arrays.asList(s.split("\\W"))));
        PredictionInput input = new PredictionInput(features);
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertNotNull((Object)predictionOutputs);
        Assertions.assertFalse((boolean)predictionOutputs.isEmpty());
        PredictionOutput output = (PredictionOutput)predictionOutputs.get(0);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getOutputs());
        Assertions.assertEquals((int)1, (int)output.getOutputs().size());
        Assertions.assertEquals((Object)"ita", (Object)((Output)output.getOutputs().get(0)).getValue().asString());
        Assertions.assertEquals((double)0.03, (double)((Output)output.getOutputs().get(0)).getScore(), (double)0.01);
        Prediction prediction = new Prediction(input, output);
        Map saliencyMap = (Map)limeExplainer.explainAsync(prediction, model).get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit());
        for (Saliency saliency : saliencyMap.values()) {
            Assertions.assertNotNull((Object)saliency);
            double i1 = ExplainabilityMetrics.impactScore((PredictionProvider)model, (Prediction)prediction, (List)saliency.getPositiveFeatures(3));
            Assertions.assertEquals((double)1.0, (double)i1);
        }
        Assertions.assertDoesNotThrow(() -> ValidationUtils.validateLocalSaliencyStability((PredictionProvider)model, (Prediction)prediction, (LocalExplainer)limeExplainer, (int)2, (double)0.8, (double)0.8));
    }

    private static /* synthetic */ CompletableFuture lambda$testOpenNLPLangDetect$1(LanguageDetector languageDetector, List inputs) {
        return CompletableFuture.supplyAsync(() -> {
            LinkedList<PredictionOutput> results = new LinkedList<PredictionOutput>();
            for (PredictionInput predictionInput : inputs) {
                StringBuilder builder = new StringBuilder();
                for (Feature f : predictionInput.getFeatures()) {
                    if (builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(f.getValue().asString());
                }
                Language language = languageDetector.predictLanguage((CharSequence)builder.toString());
                PredictionOutput predictionOutput = new PredictionOutput(List.of(new Output("lang", Type.TEXT, new Value((Object)language.getLang()), language.getConfidence())));
                results.add(predictionOutput);
            }
            return results;
        });
    }
}

