/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.explainability.integrationtests.opennlp;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.ExplainabilityMetrics;

class OpenNLPLimeExplainerTest {
    OpenNLPLimeExplainerTest() {
    }

    @BeforeAll
    static void init() {
        Config.INSTANCE.setAsyncTimeout(5000L);
        Config.INSTANCE.setAsyncTimeUnit(TimeUnit.MILLISECONDS);
    }

    @Test
    void testOpenNLPLangDetect() throws Exception {
        Random random = new Random();
        for (int seed = 0; seed < 5; ++seed) {
            random.setSeed(seed);
            LimeExplainer limeExplainer = new LimeExplainer(100, 2, random);
            InputStream is = this.getClass().getResourceAsStream("/opennlp/langdetect-183.bin");
            LanguageDetectorModel languageDetectorModel = new LanguageDetectorModel(is);
            String inputText = "italiani, spaghetti pizza mandolino";
            LanguageDetectorME languageDetector = new LanguageDetectorME(languageDetectorModel);
            Language bestLanguage = languageDetector.predictLanguage((CharSequence)inputText);
            LinkedList<Feature> features = new LinkedList<Feature>();
            features.add(FeatureFactory.newFulltextFeature((String)"text", (String)inputText));
            PredictionInput input = new PredictionInput(features);
            PredictionOutput output = new PredictionOutput(List.of(new Output("lang", Type.TEXT, new Value((Object)bestLanguage.getLang()), bestLanguage.getConfidence())));
            Prediction prediction = new Prediction(input, output);
            PredictionProvider model = arg_0 -> OpenNLPLimeExplainerTest.lambda$testOpenNLPLangDetect$1((LanguageDetector)languageDetector, arg_0);
            Map saliencyMap = (Map)limeExplainer.explainAsync(prediction, model).get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit());
            for (Saliency saliency : saliencyMap.values()) {
                Assertions.assertNotNull((Object)saliency);
                double i1 = ExplainabilityMetrics.impactScore((PredictionProvider)model, (Prediction)prediction, (List)saliency.getPositiveFeatures(3));
                Assertions.assertEquals((double)1.0, (double)i1);
            }
        }
    }

    private static /* synthetic */ CompletableFuture lambda$testOpenNLPLangDetect$1(LanguageDetector languageDetector, List inputs) {
        return CompletableFuture.supplyAsync(() -> {
            LinkedList<PredictionOutput> results = new LinkedList<PredictionOutput>();
            for (PredictionInput predictionInput : inputs) {
                StringBuilder builder = new StringBuilder();
                for (Feature f : predictionInput.getFeatures()) {
                    if (builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(f.getValue().asString());
                }
                Language language = languageDetector.predictLanguage((CharSequence)builder.toString());
                PredictionOutput predictionOutput = new PredictionOutput(List.of(new Output("lang", Type.TEXT, new Value((Object)language.getLang()), language.getConfidence())));
                results.add(predictionOutput);
            }
            return results;
        });
    }
}

