/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.modelcompiler.builder.generator.RuleUnitInstanceSourceClass;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.impl.AbstractRuleUnit;

public class RuleUnitSourceClass {
    private final String packageName;
    private final String typeName;
    private final String generatedSourceFile;
    private final String sourceFilePath;
    private final String completePath;
    private final String canonicalName;
    private final String targetCanonicalName;
    private String targetTypeName;
    private boolean hasCdi;

    public RuleUnitSourceClass(String packageName, String typeName, String generatedSourceFile) {
        this.packageName = packageName;
        this.typeName = typeName;
        this.generatedSourceFile = generatedSourceFile;
        this.canonicalName = packageName + "." + typeName;
        this.targetTypeName = typeName + "RuleUnit";
        this.targetCanonicalName = packageName + "." + this.targetTypeName;
        this.sourceFilePath = this.targetCanonicalName.replace('.', '/') + ".java";
        this.completePath = "src/main/java/" + this.sourceFilePath;
    }

    public String targetCanonicalName() {
        return this.targetCanonicalName;
    }

    public String targetTypeName() {
        return this.targetTypeName;
    }

    public void write(MemoryFileSystem srcMfs) {
        srcMfs.write(this.completePath, this.generate().getBytes());
    }

    public String generate() {
        return this.compilationUnit().toString();
    }

    public CompilationUnit compilationUnit() {
        CompilationUnit compilationUnit = new CompilationUnit(this.packageName);
        compilationUnit.getTypes().add((Node)this.classDeclaration());
        return compilationUnit;
    }

    private MethodDeclaration createInstanceMethod(String ruleUnitInstanceFQCN) {
        MethodDeclaration methodDeclaration = new MethodDeclaration();
        ReturnStmt returnStmt = new ReturnStmt((Expression)((ObjectCreationExpr)new ObjectCreationExpr().setType(ruleUnitInstanceFQCN)).setArguments(NodeList.nodeList((Node[])new Expression[]{new ThisExpr(), new NameExpr("value"), this.newKieSession()})));
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)methodDeclaration.setName("createInstance")).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).addParameter(this.canonicalName, "value")).setType(ruleUnitInstanceFQCN)).setBody((BlockStmt)new BlockStmt().addStatement((Statement)returnStmt));
        return methodDeclaration;
    }

    private MethodCallExpr newKieSession() {
        MethodCallExpr createKieBaseFromModel = this.createKieBaseFromModel();
        return new MethodCallExpr((Expression)createKieBaseFromModel, "newKieSession");
    }

    private MethodCallExpr createKieBaseFromModel() {
        MethodCallExpr args = this.args();
        return (MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("org.drools.modelcompiler.builder.KieBaseBuilder"), "createKieBaseFromModel").addArgument((Expression)args);
    }

    private MethodCallExpr args() {
        return (MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("java.util.Collections"), "singletonList").addArgument((Expression)new ObjectCreationExpr().setType(this.generatedSourceFile));
    }

    public static ClassOrInterfaceType ruleUnitType(String canonicalName) {
        return (ClassOrInterfaceType)new ClassOrInterfaceType(null, RuleUnit.class.getCanonicalName()).setTypeArguments(new Type[]{new ClassOrInterfaceType(null, canonicalName)});
    }

    public static ClassOrInterfaceType abstractRuleUnitType(String canonicalName) {
        return (ClassOrInterfaceType)new ClassOrInterfaceType(null, AbstractRuleUnit.class.getCanonicalName()).setTypeArguments(new Type[]{new ClassOrInterfaceType(null, canonicalName)});
    }

    public ClassOrInterfaceDeclaration classDeclaration() {
        ClassOrInterfaceDeclaration cls = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration().setName(this.targetTypeName)).setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        cls.addAnnotation("javax.inject.Singleton");
        String ruleUnitInstanceFQCN = RuleUnitInstanceSourceClass.qualifiedName(this.packageName, this.typeName);
        MethodDeclaration methodDeclaration = this.createInstanceMethod(ruleUnitInstanceFQCN);
        ((ClassOrInterfaceDeclaration)cls.addExtendedType(RuleUnitSourceClass.abstractRuleUnitType(this.canonicalName))).addMember((BodyDeclaration)methodDeclaration);
        return cls;
    }

    public RuleUnitSourceClass withCdi(boolean hasCdi) {
        this.hasCdi = hasCdi;
        return this;
    }
}

