/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.addon.TypeResolver;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.rule.Behavior;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.time.TimeUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.model.Rule;
import org.drools.model.Variable;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.ParseExpressionErrorResult;
import org.drools.modelcompiler.builder.errors.UnknownDeclarationError;
import org.drools.modelcompiler.builder.generator.Consequence;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.FunctionGenerator;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.WindowReferenceGenerator;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyperContext;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.util.ClassUtil;
import org.drools.modelcompiler.util.StringUtil;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.kogito.rules.DataSource;

public class ModelGenerator {
    private static final Map<String, String> attributesMap = new HashMap<String, String>();
    public static final Set<String> temporalOperators = new HashSet<String>();
    public static final boolean GENERATE_EXPR_ID = true;

    public static void generateModel(KnowledgeBuilderImpl kbuilder, InternalKnowledgePackage pkg, PackageDescr packageDescr, PackageModel packageModel, boolean isPattern) {
        TypeResolver typeResolver = pkg.getTypeResolver();
        packageModel.addImports(pkg.getImports().keySet());
        packageModel.addStaticImports(pkg.getStaticImports());
        packageModel.addEntryPoints(packageDescr.getEntryPointDeclarations());
        packageModel.addGlobals(pkg);
        packageModel.addAccumulateFunctions(pkg.getAccumulateFunctions());
        packageModel.setInternalKnowledgePackage(pkg);
        new WindowReferenceGenerator(packageModel, typeResolver).addWindowReferences(kbuilder, packageDescr.getWindowDeclarations());
        packageModel.addAllFunctions(packageDescr.getFunctions().stream().map(FunctionGenerator::toFunction).collect(Collectors.toList()));
        for (RuleDescr descr : packageDescr.getRules()) {
            RuleContext context = new RuleContext(kbuilder, packageModel, typeResolver, isPattern);
            context.setDialectFromAttributes(packageDescr.getAttributes());
            if (!(descr instanceof QueryDescr)) continue;
            QueryGenerator.processQueryDef(packageModel, (QueryDescr)descr, context);
        }
        HashSet<RuleUnitDescription> ruleUnitDescriptions = new HashSet<RuleUnitDescription>();
        for (RuleDescr descr : packageDescr.getRules()) {
            RuleContext context = new RuleContext(kbuilder, packageModel, typeResolver, isPattern);
            context.setDialectFromAttributes(packageDescr.getAttributes());
            if (descr instanceof QueryDescr) {
                QueryGenerator.processQuery(kbuilder, packageModel, (QueryDescr)descr);
                continue;
            }
            ModelGenerator.processRule(kbuilder, packageModel, packageDescr, descr, context);
            RuleUnitDescription ruleUnitDescr = context.getRuleUnitDescr();
            if (ruleUnitDescr == null) continue;
            ruleUnitDescriptions.add(ruleUnitDescr);
        }
        for (RuleUnitDescription rud : ruleUnitDescriptions) {
            Class ruc = rud.getRuleUnitClass();
            packageModel.addRuleUnit(ruc);
        }
    }

    private static void processRule(KnowledgeBuilderImpl kbuilder, PackageModel packageModel, PackageDescr packageDescr, RuleDescr ruleDescr, RuleContext context) {
        context.setDescr(ruleDescr);
        context.addGlobalDeclarations(packageModel.getGlobals());
        for (Map.Entry kv : ruleDescr.getNamedConsequences().entrySet()) {
            context.addNamedConsequence((String)kv.getKey(), kv.getValue().toString());
        }
        context.setDialectFromAttributes(ruleDescr.getAttributes().values());
        RuleUnitDescription ruleUnitDescr = context.getRuleUnitDescr();
        if (ruleUnitDescr != null) {
            ModelGenerator.processUnitData(context, ruleUnitDescr);
        }
        new ModelGeneratorVisitor(context, packageModel).visit(ModelGenerator.getExtendedLhs(packageDescr, ruleDescr));
        String ruleMethodName = "rule_" + StringUtil.toId(ruleDescr.getName());
        MethodDeclaration ruleMethod = new MethodDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier()}), (com.github.javaparser.ast.type.Type)DrlxParseUtil.toClassOrInterfaceType(Rule.class), ruleMethodName);
        ruleMethod.setJavadocComment(" Rule name: " + ruleDescr.getName() + " ");
        VariableDeclarationExpr ruleVar = new VariableDeclarationExpr((com.github.javaparser.ast.type.Type)DrlxParseUtil.toClassOrInterfaceType(Rule.class), "rule");
        MethodCallExpr ruleCall = new MethodCallExpr(null, "D.rule");
        if (!ruleDescr.getNamespace().isEmpty()) {
            ruleCall.addArgument((Expression)new StringLiteralExpr(ruleDescr.getNamespace()));
        }
        ruleCall.addArgument((Expression)new StringLiteralExpr(ruleDescr.getName()));
        MethodCallExpr buildCallScope = ruleUnitDescr != null ? (MethodCallExpr)new MethodCallExpr((Expression)ruleCall, "unit").addArgument((Expression)new ClassExpr(DrlxParseUtil.classToReferenceType(ruleUnitDescr.getRuleUnitClass()))) : ruleCall;
        for (MethodCallExpr attributeExpr : ModelGenerator.ruleAttributes(context, ruleDescr)) {
            attributeExpr.setScope((Expression)buildCallScope);
            buildCallScope = attributeExpr;
        }
        for (MethodCallExpr metaAttributeExpr : ModelGenerator.ruleMetaAttributes(context, ruleDescr)) {
            metaAttributeExpr.setScope((Expression)buildCallScope);
            buildCallScope = metaAttributeExpr;
        }
        MethodCallExpr buildCall = new MethodCallExpr((Expression)buildCallScope, "build", NodeList.nodeList(context.getExpressions()));
        BlockStmt ruleVariablesBlock = new BlockStmt();
        ModelGenerator.createVariables(kbuilder, ruleVariablesBlock, packageModel, context);
        ruleMethod.setBody(ruleVariablesBlock);
        MethodCallExpr executeCall = new Consequence(context).createCall(ruleDescr, ruleDescr.getConsequence().toString(), ruleVariablesBlock, false);
        buildCall.addArgument((Expression)executeCall);
        ruleVariablesBlock.addStatement((Expression)new AssignExpr((Expression)ruleVar, (Expression)buildCall, AssignExpr.Operator.ASSIGN));
        ruleVariablesBlock.addStatement((Statement)new ReturnStmt("rule"));
        packageModel.putRuleMethod(ruleMethodName, ruleMethod);
    }

    private static AndDescr getExtendedLhs(PackageDescr packageDescr, RuleDescr ruleDescr) {
        if (ruleDescr.getParentName() == null) {
            return ruleDescr.getLhs();
        }
        RuleDescr parent = packageDescr.getRules().stream().filter(r -> r.getName().equals(ruleDescr.getParentName())).findFirst().orElseThrow(() -> new RuntimeException("Rule " + ruleDescr.getName() + " extends an unknown rule " + ruleDescr.getParentName()));
        AndDescr extendedLhs = new AndDescr();
        ModelGenerator.getExtendedLhs(packageDescr, parent).getDescrs().forEach(arg_0 -> ((AndDescr)extendedLhs).addDescr(arg_0));
        ruleDescr.getLhs().getDescrs().forEach(arg_0 -> ((AndDescr)extendedLhs).addDescr(arg_0));
        return extendedLhs;
    }

    private static List<MethodCallExpr> ruleAttributes(RuleContext context, RuleDescr ruleDescr) {
        ArrayList<MethodCallExpr> ruleAttributes = new ArrayList<MethodCallExpr>();
        Set excludingDialect = ruleDescr.getAttributes().entrySet().stream().filter(r -> !((String)r.getKey()).equals("dialect")).collect(Collectors.toSet());
        for (Map.Entry as : excludingDialect) {
            MethodCallExpr attributeCall = new MethodCallExpr(null, "attribute");
            attributeCall.addArgument(attributesMap.get(as.getKey()));
            String value = ((AttributeDescr)as.getValue()).getValue().trim();
            switch ((String)as.getKey()) {
                case "salience": {
                    try {
                        Integer.parseInt(value);
                        attributeCall.addArgument(value);
                    }
                    catch (NumberFormatException nfe) {
                        ModelGenerator.addDynamicAttributeArgument(context, attributeCall, value);
                    }
                    break;
                }
                case "enabled": {
                    if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                        attributeCall.addArgument(value.toLowerCase());
                        break;
                    }
                    ModelGenerator.addDynamicAttributeArgument(context, attributeCall, value);
                    break;
                }
                case "no-loop": 
                case "auto-focus": 
                case "lock-on-active": {
                    attributeCall.addArgument(value);
                    break;
                }
                case "agenda-group": 
                case "activation-group": 
                case "ruleflow-group": 
                case "duration": 
                case "timer": {
                    attributeCall.addArgument((Expression)new StringLiteralExpr(value));
                    break;
                }
                case "calendars": {
                    if (value.startsWith("[")) {
                        value = value.substring(1, value.length() - 1).trim();
                    }
                    Expression arrayExpr = StaticJavaParser.parseExpression((String)("new String[] { " + value + " }"));
                    attributeCall.addArgument(arrayExpr);
                    break;
                }
                case "date-effective": 
                case "date-expires": {
                    attributeCall.addArgument(StaticJavaParser.parseExpression((String)String.format("GregorianCalendar.from(LocalDate.parse(\"%s\", DATE_TIME_FORMATTER).atStartOfDay(ZoneId.systemDefault()))", ((AttributeDescr)as.getValue()).getValue())));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case for rule attribute: " + (String)as.getKey());
                }
            }
            ruleAttributes.add(attributeCall);
        }
        return ruleAttributes;
    }

    private static void addDynamicAttributeArgument(RuleContext context, MethodCallExpr attributeCall, String value) {
        ExpressionTyperContext expressionTyperContext = new ExpressionTyperContext();
        ExpressionTyper expressionTyper = new ExpressionTyper(context, Integer.class, null, false, expressionTyperContext);
        Expression salienceExpr = StaticJavaParser.parseExpression((String)value);
        Optional<TypedExpression> typedExpression = expressionTyper.toTypedExpression(salienceExpr).getTypedExpression();
        if (typedExpression.isPresent()) {
            Expression lambda = DrlxParseUtil.generateLambdaWithoutParameters(expressionTyperContext.getUsedDeclarations(), typedExpression.get().getExpression(), true);
            MethodCallExpr supplyCall = new MethodCallExpr(null, "D.supply");
            expressionTyperContext.getUsedDeclarations().stream().map(context::getVarExpr).forEach(arg_0 -> ((MethodCallExpr)supplyCall).addArgument(arg_0));
            supplyCall.addArgument(lambda);
            attributeCall.addArgument((Expression)supplyCall);
        } else {
            context.addCompilationError((KnowledgeBuilderResult)new ParseExpressionErrorResult(salienceExpr));
        }
    }

    private static List<MethodCallExpr> ruleMetaAttributes(RuleContext context, RuleDescr ruleDescr) {
        ArrayList<MethodCallExpr> ruleMetaAttributes = new ArrayList<MethodCallExpr>();
        for (String metaAttr : ruleDescr.getAnnotationNames()) {
            MethodCallExpr metaAttributeCall = new MethodCallExpr("metadata", new Expression[0]);
            metaAttributeCall.addArgument((Expression)new StringLiteralExpr(metaAttr));
            AnnotationDescr ad = ruleDescr.getAnnotation(metaAttr);
            String adFqn = ad.getFullyQualifiedName();
            if (adFqn != null) {
                AnnotationDefinition annotationDefinition;
                try {
                    annotationDefinition = AnnotationDefinition.build((Class)context.getTypeResolver().resolveType(adFqn), (Map)ad.getValueMap(), (TypeResolver)context.getTypeResolver());
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                if (annotationDefinition.getValues().size() == 1 && annotationDefinition.getValues().containsKey("value")) {
                    Object annValue = annotationDefinition.getPropertyValue("value");
                    metaAttributeCall.addArgument((Expression)new StringLiteralExpr(annValue.toString()));
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>(annotationDefinition.getValues().size());
                    for (String key : annotationDefinition.getValues().keySet()) {
                        map.put(key, annotationDefinition.getPropertyValue(key));
                    }
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(map));
                }
            } else if (ad.hasValue()) {
                if (ad.getValues().size() == 1) {
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(ModelGenerator.resolveValue(ad.getSingleValueAsString())));
                } else {
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(ad.getValueMap()));
                }
            } else {
                metaAttributeCall.addArgument((Expression)new NullLiteralExpr());
            }
            ruleMetaAttributes.add(metaAttributeCall);
        }
        return ruleMetaAttributes;
    }

    private static Expression objectAsJPExpression(Object annValue) {
        if (annValue instanceof String) {
            StringLiteralExpr aStringLiteral = new StringLiteralExpr();
            aStringLiteral.setString(annValue.toString());
            return aStringLiteral;
        }
        if (annValue instanceof Number) {
            return StaticJavaParser.parseExpression((String)annValue.toString());
        }
        if (annValue instanceof Map) {
            throw new UnsupportedOperationException("cannot define a canonical representation for a java.util.Map yet.");
        }
        throw new UnsupportedOperationException("I was unable to define a canonical String representation to give to JP yet about: " + annValue);
    }

    private static Object resolveValue(String value) {
        Object result = value;
        try {
            result = MVELSafeHelper.getEvaluator().eval(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void processUnitData(RuleContext context, RuleUnitDescription ruleUnitDescr) {
        for (Map.Entry unitVar : ruleUnitDescr.getUnitVarAccessors().entrySet()) {
            String unitVarName = (String)unitVar.getKey();
            Type type = ((Method)unitVar.getValue()).getGenericReturnType();
            Class<?> rawClass = ClassUtil.toRawClass(type);
            Class<?> resolvedType = ruleUnitDescr.getDatasourceType(unitVarName).orElse(rawClass);
            com.github.javaparser.ast.type.Type declType = DrlxParseUtil.classToReferenceType(rawClass);
            context.addRuleUnitVar(unitVarName, resolvedType);
            context.getPackageModel().addGlobal(unitVarName, rawClass);
            if (!DataSource.class.isAssignableFrom(rawClass)) continue;
            context.getPackageModel().addEntryPoint(unitVarName);
        }
    }

    public static void createVariables(KnowledgeBuilderImpl kbuilder, BlockStmt block, PackageModel packageModel, RuleContext context) {
        for (DeclarationSpec decl : context.getAllDeclarations()) {
            boolean domainClass = packageModel.registerDomainClass(decl.getDeclarationClass());
            if (packageModel.getGlobals().containsKey(decl.getBindingId()) || context.queryParameterWithName(p -> p.name.equals(decl.getBindingId())).isPresent()) continue;
            ModelGenerator.addVariable(kbuilder, block, decl, context, domainClass);
        }
    }

    private static void addVariable(KnowledgeBuilderImpl kbuilder, BlockStmt ruleBlock, DeclarationSpec decl, RuleContext context, boolean domainClass) {
        if (decl.getDeclarationClass() == null) {
            kbuilder.addBuilderResult((KnowledgeBuilderResult)new UnknownDeclarationError(decl.getBindingId()));
            return;
        }
        com.github.javaparser.ast.type.Type declType = DrlxParseUtil.classToReferenceType(decl.getDeclarationClass());
        ClassOrInterfaceType varType = DrlxParseUtil.toClassOrInterfaceType(Variable.class);
        varType.setTypeArguments(new com.github.javaparser.ast.type.Type[]{declType});
        VariableDeclarationExpr var_ = new VariableDeclarationExpr((com.github.javaparser.ast.type.Type)varType, context.getVar(decl.getBindingId()), new Modifier[]{Modifier.finalModifier()});
        MethodCallExpr declarationOfCall = new MethodCallExpr(null, "D.declarationOf");
        declarationOfCall.addArgument((Expression)new ClassExpr(decl.getBoxedType()));
        if (domainClass) {
            String domainClassSourceName = ClassUtil.asJavaSourceName(decl.getDeclarationClass());
            declarationOfCall.addArgument("DomainClassesMetadata" + context.getPackageModel().getPackageUUID() + "." + (String)domainClassSourceName + "_Metadata_INSTANCE");
        }
        declarationOfCall.addArgument((Expression)new StringLiteralExpr(decl.getVariableName().orElse(decl.getBindingId())));
        decl.getDeclarationSource().ifPresent(arg_0 -> ((MethodCallExpr)declarationOfCall).addArgument(arg_0));
        decl.getEntryPoint().ifPresent(ep -> {
            MethodCallExpr entryPointCall = new MethodCallExpr(null, "D.entryPoint");
            entryPointCall.addArgument((Expression)new StringLiteralExpr(ep));
            declarationOfCall.addArgument((Expression)entryPointCall);
        });
        for (BehaviorDescr behaviorDescr : decl.getBehaviors()) {
            MethodCallExpr windowCall = new MethodCallExpr(null, "D.window");
            if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
                windowCall.addArgument("Window.Type.TIME");
                windowCall.addArgument("" + TimeUtils.parseTimeString((String)((String)behaviorDescr.getParameters().get(0))));
            }
            if (Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) {
                windowCall.addArgument("Window.Type.LENGTH");
                windowCall.addArgument("" + Integer.valueOf((String)behaviorDescr.getParameters().get(0)));
            }
            declarationOfCall.addArgument((Expression)windowCall);
        }
        AssignExpr var_assign = new AssignExpr((Expression)var_, (Expression)declarationOfCall, AssignExpr.Operator.ASSIGN);
        ruleBlock.addStatement((Expression)var_assign);
    }

    static {
        attributesMap.put("no-loop", "Rule.Attribute.NO_LOOP");
        attributesMap.put("salience", "Rule.Attribute.SALIENCE");
        attributesMap.put("enabled", "Rule.Attribute.ENABLED");
        attributesMap.put("auto-focus", "Rule.Attribute.AUTO_FOCUS");
        attributesMap.put("lock-on-active", "Rule.Attribute.LOCK_ON_ACTIVE");
        attributesMap.put("agenda-group", "Rule.Attribute.AGENDA_GROUP");
        attributesMap.put("activation-group", "Rule.Attribute.ACTIVATION_GROUP");
        attributesMap.put("ruleflow-group", "Rule.Attribute.RULEFLOW_GROUP");
        attributesMap.put("duration", "Rule.Attribute.DURATION");
        attributesMap.put("timer", "Rule.Attribute.TIMER");
        attributesMap.put("calendars", "Rule.Attribute.CALENDARS");
        attributesMap.put("date-effective", "Rule.Attribute.DATE_EFFECTIVE");
        attributesMap.put("date-expires", "Rule.Attribute.DATE_EXPIRES");
        temporalOperators.add("before");
        temporalOperators.add("after");
        temporalOperators.add("coincides");
        temporalOperators.add("metby");
        temporalOperators.add("finishedby");
        temporalOperators.add("overlaps");
        temporalOperators.add("meets");
        temporalOperators.add("during");
        temporalOperators.add("finishes");
        temporalOperators.add("startedby");
        temporalOperators.add("overlappedby");
        temporalOperators.add("includes");
        temporalOperators.add("starts");
    }
}

