/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.printer.PrettyPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.PackageModel;

public class ModelWriter {
    public static final String CDI_ANNOTATION = "@javax.enterprise.context.ApplicationScoped";
    private String dependencyInjection = "@javax.enterprise.context.ApplicationScoped";

    public ModelWriter withCdi(String dependencyInjection) {
        this.dependencyInjection = dependencyInjection;
        return this;
    }

    public Result writeModel(MemoryFileSystem srcMfs, Collection<PackageModel> packageModels, boolean oneClassPerRule) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        ArrayList<String> modelFiles = new ArrayList<String>();
        PrettyPrinter prettyPrinter = JavaParserCompiler.getPrettyPrinter();
        for (PackageModel pkgModel : packageModels) {
            String pojoSourceName;
            String source;
            String pkgName = pkgModel.getName();
            String folderName = pkgName.replace('.', '/');
            for (ClassOrInterfaceDeclaration classOrInterfaceDeclaration : pkgModel.getGeneratedPOJOsSource()) {
                source = JavaParserCompiler.toPojoSource(pkgModel.getName(), pkgModel.getImports(), pkgModel.getStaticImports(), classOrInterfaceDeclaration);
                pojoSourceName = "src/main/java/" + folderName + "/" + classOrInterfaceDeclaration.getName() + ".java";
                this.addSource(srcMfs, sourceFiles, pkgModel, pojoSourceName, source);
            }
            for (GeneratedClassWithPackage generatedClassWithPackage : pkgModel.getGeneratedAccumulateClasses()) {
                source = JavaParserCompiler.toPojoSource(pkgModel.getName(), generatedClassWithPackage.getImports(), pkgModel.getStaticImports(), generatedClassWithPackage.getGeneratedClass());
                pojoSourceName = "src/main/java/" + folderName + "/" + generatedClassWithPackage.getGeneratedClass().getName() + ".java";
                this.addSource(srcMfs, sourceFiles, pkgModel, pojoSourceName, source);
            }
            PackageModel.RuleSourceResult rulesSourceResult = pkgModel.getRulesSource(oneClassPerRule);
            String string = pkgModel.getRulesFileName();
            String rulesSourceName = "src/main/java/" + folderName + "/" + string + ".java";
            String rulesSource = prettyPrinter.print((Node)rulesSourceResult.getMainRuleClass());
            this.addSource(srcMfs, sourceFiles, pkgModel, rulesSourceName, rulesSource);
            modelFiles.add(pkgName + "." + string);
            for (CompilationUnit cu : rulesSourceResult.getSplitted()) {
                String addFileName = ((ClassOrInterfaceDeclaration)cu.findFirst(ClassOrInterfaceDeclaration.class).get()).getNameAsString();
                String sourceName = "src/main/java/" + folderName + "/" + addFileName + ".java";
                this.addSource(srcMfs, sourceFiles, pkgModel, sourceName, prettyPrinter.print((Node)cu));
            }
            String sourceName = "src/main/java/" + folderName + "/" + "DomainClassesMetadata" + pkgModel.getPackageUUID() + ".java";
            this.addSource(srcMfs, sourceFiles, pkgModel, sourceName, pkgModel.getDomainClassesMetadataSource());
        }
        return new Result(sourceFiles, modelFiles);
    }

    private void addSource(MemoryFileSystem srcMfs, List<String> sourceFiles, PackageModel pkgModel, String sourceName, String source) {
        PackageModel.log(source);
        srcMfs.write(sourceName, source.getBytes());
        sourceFiles.add(sourceName);
    }

    public static class Result {
        private final List<String> sourceFiles;
        private final List<String> modelFiles;

        public Result(List<String> sourceFiles, List<String> modelFiles) {
            this.sourceFiles = sourceFiles;
            this.modelFiles = modelFiles;
        }

        public List<String> getSources() {
            return this.sourceFiles;
        }

        public List<String> getSourceFiles() {
            return this.sourceFiles;
        }

        public List<String> getModelFiles() {
            return this.modelFiles;
        }
    }
}

