/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationFactory;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotatedBaseDescr;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.TypeDeclaration;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DRLIdGenerator;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.POJOGenerator;
import org.kie.api.builder.ReleaseId;

public class ModelBuilderImpl
extends KnowledgeBuilderImpl {
    private final DRLIdGenerator exprIdGenerator = new DRLIdGenerator();
    private final Map<String, PackageModel> packageModels = new HashMap<String, PackageModel>();
    private final ReleaseId releaseId;
    private final boolean isPattern;

    public ModelBuilderImpl(KnowledgeBuilderConfigurationImpl configuration, ReleaseId releaseId, boolean isPattern) {
        super(configuration);
        this.releaseId = releaseId;
        this.isPattern = isPattern;
    }

    public void buildPackages(Collection<CompositePackageDescr> packages) {
        this.initPackageRegistries(packages);
        this.registerTypeDeclarations(packages);
        this.buildDeclaredTypes(packages);
        this.buildOtherDeclarations(packages);
        this.deregisterTypeDeclarations(packages);
        this.buildRules(packages);
        DrlxParseUtil.clearAccessorCache();
    }

    private void registerTypeDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            InternalKnowledgePackage pkg = this.getOrCreatePackageRegistry((PackageDescr)packageDescr).getPackage();
            for (TypeDeclarationDescr typeDescr : packageDescr.getTypeDeclarations()) {
                this.normalizeAnnotations((AnnotatedBaseDescr)typeDescr, pkg.getTypeResolver(), false);
                TypeDeclaration type = new TypeDeclaration(typeDescr.getTypeName());
                type.setResource(typeDescr.getResource());
                TypeDeclarationFactory.processAnnotations((AbstractClassTypeDeclarationDescr)typeDescr, (TypeDeclaration)type);
                pkg.addTypeDeclaration(type);
            }
        }
    }

    private void deregisterTypeDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.getOrCreatePackageRegistry((PackageDescr)packageDescr).getPackage().getTypeDeclarations().clear();
        }
    }

    protected void buildRules(Collection<CompositePackageDescr> packages) {
        if (this.hasErrors()) {
            return;
        }
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter((KnowledgeBuilderImpl.AssetFilter)packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.compileKnowledgePackages((PackageDescr)packageDescr, pkgRegistry);
            this.setAssetFilter(null);
        }
    }

    private void buildDeclaredTypes(Collection<CompositePackageDescr> packages) {
        InternalKnowledgePackage pkg;
        for (CompositePackageDescr packageDescr : packages) {
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.generatePOJOs((PackageDescr)packageDescr, pkgRegistry);
        }
        List<GeneratedClassWithPackage> allGeneratedPojos = this.packageModels.values().stream().flatMap(p -> p.getGeneratedPOJOsSource().stream().map(c -> new GeneratedClassWithPackage((ClassOrInterfaceDeclaration)c, p.getName(), p.getImports(), p.getStaticImports()))).collect(Collectors.toList());
        HashMap allCompiledClasses = new HashMap();
        for (CompositePackageDescr packageDescr : packages) {
            pkg = this.getPackageRegistry(packageDescr.getNamespace()).getPackage();
            allCompiledClasses.putAll(POJOGenerator.compileType(this, pkg.getPackageClassLoader(), allGeneratedPojos));
        }
        for (CompositePackageDescr packageDescr : packages) {
            pkg = this.getPackageRegistry(packageDescr.getNamespace()).getPackage();
            allGeneratedPojos.forEach(c -> POJOGenerator.registerType(pkg.getTypeResolver(), allCompiledClasses));
        }
    }

    protected void generatePOJOs(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        String pkgName = pkg.getName();
        PackageModel model = this.packageModels.computeIfAbsent(pkgName, s -> {
            DialectCompiletimeRegistry dialectCompiletimeRegistry = pkgRegistry.getDialectCompiletimeRegistry();
            return new PackageModel(this.releaseId.toString(), pkgName, this.getBuilderConfiguration(), this.isPattern, dialectCompiletimeRegistry, this.exprIdGenerator);
        });
        model.addImports(pkg.getTypeResolver().getImports());
        POJOGenerator.generatePOJO(this, pkg, packageDescr, model);
    }

    protected void compileKnowledgePackages(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        this.validateUniqueRuleNames(packageDescr);
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        String pkgName = pkg.getName();
        PackageModel model = this.packageModels.computeIfAbsent(pkgName, s -> {
            DialectCompiletimeRegistry dialectCompiletimeRegistry = pkgRegistry.getDialectCompiletimeRegistry();
            return new PackageModel(this.releaseId.toString(), pkgName, this.getBuilderConfiguration(), this.isPattern, dialectCompiletimeRegistry, this.exprIdGenerator);
        });
        ModelGenerator.generateModel(this, pkg, packageDescr, model, this.isPattern);
    }

    public List<PackageModel> getPackageModels() {
        return new ArrayList<PackageModel>(this.packageModels.values());
    }
}

